/*-------------------------------------------------------*/
/* util/gem-expire.c	( NTHU CS MapleBBS Ver 3.10 )    */
/*-------------------------------------------------------*/
/* target : p⥼sذ & sѼƺذϱƦ]	 */
/* create : 99/11/26                                     */
/* update : 01/08/27					 */
/* author : Jimmy.bbs@whshs.twbbs.org			 */
/* modify : itoc.bbs@bbs.tnfsh.tn.edu.tw		 */
/*-------------------------------------------------------*/
/* syntax : gem-expire					 */
/*-------------------------------------------------------*/


#include "bbs.h"

#define OUTFILE_GEMEMPTY	"gem/@/@-gem_empty"
#define OUTFILE_GEMOVERDUE	"gem/@/@-gem_overdue"


/*-------------------------------------------------------*/
/* BRD shm P cache.c ۮe			 */
/*-------------------------------------------------------*/


static BCACHE *bshm;


static void
init_bshm()
{
  /* itoc.030727: b} bbsd eAӴNnL accountA
     ҥH bshm Ӥw]wn */

  bshm = shm_new(BRDSHM_KEY, sizeof(BCACHE));

  if (bshm->uptime <= 0)	/* bshm ]w */
    exit(0);
}


/*-------------------------------------------------------*/
/* D{						 */
/*-------------------------------------------------------*/


typedef struct
{
  int day;			/* XѨSzذ */
  char brdname[BNLEN + 1];	/* OW */
  char BM[BMLEN + 1];		/* OD */
}	BRDDATA;


static int
int_cmp(a, b)
  BRDDATA *a, *b;
{
  return (b->day - a->day);	/* Ѥjƨp */
}


static BRDDATA board[MAXBOARD];
static int locus = 0;			/* `@OFXӪO */


static void
topgem()
{
  time_t now;
  struct stat st;
  BRD *bhdr, *tail;
  char fpath[64], *brdname;

  time(&now);

  bhdr = bshm->bcache;
  tail = bhdr + bshm->number;
  do
  {
    /* LCJƦ]ݪO */
    if ((bhdr->readlevel | bhdr->postlevel) >= (PERM_VALID << 1))	/* (BASIC + ... + VALID) < (VALID << 1) */
      continue;

    brdname = bhdr->brdname;
    sprintf(fpath, "gem/brd/%s/@/@log", brdname);

    if (stat(fpath, &st) != -1)	/* ذϪˬdXѥs */
      board[locus].day = (now - st.st_mtime) / 86400;
    else			/* LذϪ */
      board[locus].day = 999;
    strcpy(board[locus].brdname, brdname);
    strcpy(board[locus].BM, bhdr->BM);

    locus++;
  } while (++bhdr < tail);

  qsort(board, locus, sizeof(BRDDATA), int_cmp);
}


static void
write_data()
{
  time_t now;
  struct tm *ptime;
  FILE *fpe, *fpo;
  int i, m, n;  

  time(&now);
  ptime = localtime(&now);

  fpe = fopen(OUTFILE_GEMEMPTY, "w");
  fpo = fopen(OUTFILE_GEMOVERDUE, "w");

  fprintf(fpe,
    "         \033[1;34m-----\033[37m=====\033[41m ݪOذϥsݪO ( %d  %d ) \033[;1;37m=====\033[34m-----\033[m\n"
    "           \033[1;42m W \033[44m   ݪOW   \033[42m      ذϥs      \033[44m   O   D    \033[m\n",
    ptime->tm_mon + 1, ptime->tm_mday);

  fprintf(fpo,
    "        \033[1;34m-----\033[37m=====\033[41m ݪOذϥsѼƤݪO ( %d  %d ) \033[;1;37m=====\033[34m-----\033[m\n"
    "              \033[1;42m W \033[44m    ݪOW    \033[42m ذϥsѼ \033[44m   O   D    \033[m\n",
    ptime->tm_mon + 1, ptime->tm_mday);

  m = 1;
  n = 1;

  for (i = 0; i < locus; i++)
  {
    if (board[i].day == 999)
    {
      fprintf(fpe, "            %3d   %12s     %s      %.20s\n",
	m, board[i].brdname, "|sذ", board[i].BM);
      m++;
    }
    else
    {
      fprintf(fpo, "                %s%3d    %12s        %4d       %.20s\033[m\n",
	n <= 3 ? "\033[1m" : (n <= 10 ? "\033[1;31m" : "\033[m"),
	n, board[i].brdname, board[i].day, board[i].BM);
      n++;
    }
  }

  fclose(fpe);
  fclose(fpo);
}


int 
main()
{
  chdir(BBSHOME);

  init_bshm();

  topgem();
  write_data();

  return 0;
}
