/*-------------------------------------------------------*/
/* util/counter.c	( NTHU CS MapleBBS Ver 3.10 )	 */
/*-------------------------------------------------------*/
/* target : vy					 */
/* create : 03/03/03					 */
/* update :   /  /  					 */
/* author : itoc.bbs@bbs.tnfsh.tn.edu.tw		 */
/*-------------------------------------------------------*/


#include "bbs.h"


#define OUTFILE_COUNTER		"gem/@/@-counter"
#define FN_RUN_COUNTER		"run/var/counter"


typedef struct
{
  time_t uptime;		/* sɶ */

  int total_acct;		/* W`@h֨ϥΪ̵U */
  int online_usr;		/* uWPɦh֨ϥΪ */
  int today_usr;		/* `@XӤHW */
  int online_usr_every_hour[24];/* UIuWh֨ϥΪ */
  int total_brd;		/* W`@h֬ݪO */

  char ident[12];		/* dեHXR */
}      COUNTER;


#define break_record(new, old)	(new > old + old / 20)	/* sWL¬ 5% HWɡANg */


int
main()
{
  UCACHE *ushm;
  COUNTER counter;

  int num;
  char *fname, date[20];
  FILE *fp;
  time_t now;
  struct tm *ptime;

  chdir(BBSHOME);

  if (!(fp = fopen(OUTFILE_COUNTER, "a+")))
    return -1;

  fname = FN_RUN_COUNTER;

  memset(&counter, 0, sizeof(COUNTER));
  rec_get(fname, &counter, sizeof(COUNTER), 0);

  counter.uptime = time(&now);
  ptime = localtime(&now);
  sprintf(date, "i%02d/%02d/%02d %02d:%02dj", 
    ptime->tm_year % 100, ptime->tm_mon + 1, ptime->tm_mday, ptime->tm_hour, ptime->tm_min);


  /* UH */
  num = rec_num(FN_SCHEMA, sizeof(SCHEMA));
  if (break_record(num, counter.total_acct))
  {
    fprintf(fp, " %s \033[31mUH\033[mgPWL \033[1;31m%d\033[m H\n", date, num);
    counter.total_acct = num;
  }

  /* uWH */
  ushm = shm_new(UTMPSHM_KEY, sizeof(UCACHE));
  num = ushm->count;
  if (break_record(num, counter.online_usr))
  {
    fprintf(fp, " %s \033[32mPɽuWH\033[mF \033[1;32m%d\033[m H\n", date, num);
    counter.online_usr = num;
  }
  counter.online_usr_every_hour[ptime->tm_hour] = num;	/* pɪuWHơANo sample  */

  /* WH */
  if (ptime->tm_hour == 23)	/* Cѭp@WH */
  {
    int i;

    /* itoc.: oӭȬOTA]uOCӤp sample MA
       ӥBٰ]CӤHbWɶO 60  */
    num = 0;
    for (i = 0; i < 24; i++)
      num += counter.online_usr_every_hour[i];

    if (break_record(num, counter.today_usr))
    {
      fprintf(fp, " %s \033[33mWH\033[m} \033[1;33m%d\033[m H\n", date, num);
      counter.today_usr = num;
    }
  }

  /* ݪOӼ */
  num = rec_num(FN_BRD, sizeof(BRD));
  if (break_record(num, counter.total_brd))
  {
    fprintf(fp, " %s \033[34mݪOӼ\033[mŧGF \033[1;34m%d\033[m \n", date, num);
    counter.total_brd = num;
  }


  rec_put(fname, &counter, sizeof(COUNTER), 0, NULL);

  fclose(fp);
  return 0;
}
