/*-------------------------------------------------------*/
/* vote.c	( NTHU CS MapleBBS Ver 2.36 )		 */
/*-------------------------------------------------------*/
/* target : boards' vote routines		 	 */
/* create : 95/03/29				 	 */
/* update : 95/12/15				 	 */
/*-------------------------------------------------------*/
/* brd/_/.VCH  : Vote Control Header    ثeҦ벼 */
/* brd/_/@vote : vote history           Lh벼v	 */
/* brd/_/@/@_  : vote description       벼	 */
/* brd/_/@/I_  : vote selection Items   벼ﶵ	 */
/* brd/_/@/O_  : users' Opinions        ϥΪ̦ܭn	 */
/* brd/_/@/L_  : can vote List          i벼W	 */
/* brd/_/@/G_  : voted id loG file      wⲼW	 */
/* brd/_/@/Z_  : final/temporary result	벼G	 */
/*-------------------------------------------------------*/


#include "bbs.h"


extern BCACHE *bshm;
extern XZ xz[];
extern char xo_pool[];


static char *
vch_fpath(fpath, folder, vch)
  char *fpath, *folder;
  VCH *vch;
{
  /* VCH M HDR  xname ǰtAҥHɥ hdr_fpath() */
  hdr_fpath(fpath, folder, (HDR *) vch);
  return strrchr(fpath, '@');
}


static int vote_add();


int
vote_result(xo)
  XO *xo;
{
  char fpath[64];

  setdirpath(fpath, xo->dir, "@/@vote");
  /* Thor.990204: Ҽ{more Ǧ^ */   
  if (more(fpath, NULL) >= 0)
    return XO_HEAD;	/* XZ_POST M XZ_VOTE @ vote_result() */

  vmsg("ثeS}G");
  return XO_FOOT;
}


static void
vote_item(num, vch)
  int num;
  VCH *vch;
{
  prints("%6d%c%c%c%c%c %-9.8s%-12s %.44s\n",
    num, tag_char(vch->chrono), vch->vgamble, vch->vsort, vch->vpercent, vch->vprivate, 
    vch->cdate, vch->owner, vch->title);
}


static int
vote_body(xo)
  XO *xo;
{
  VCH *vch;
  int num, max, tail;

  max = xo->max;
  if (max <= 0)
  {
    if (bbstate & STAT_BOARD)
    {
      if (vans("n|벼(Y/N)H[N] ") == 'y')
	return vote_add(xo);
    }
    else
    {
      vmsg("ثeõL벼|");
    }
    return XO_QUIT;
  }

  vch = (VCH *) xo_pool;
  num = xo->top;
  tail = num + XO_TALL;
  if (max > tail)
    max = tail;

  move(3, 0);
  do
  {
    vote_item(++num, vch++);
  } while (num < max);
  clrtobot();

  /* return XO_NONE; */
  return XO_FOOT;	/* itoc.010403:  b_lines W feeter */
}


static int
vote_head(xo)
  XO *xo;
{
  vs_head(currBM, "벼");
  prints(NECKER_VOTE, d_cols, "");
  return vote_body(xo);
}


static int
vote_init(xo)
  XO *xo;
{
  xo_load(xo, sizeof(VCH));
  return vote_head(xo);
}


static int
vote_load(xo)
  XO *xo;
{
  xo_load(xo, sizeof(VCH));
  return vote_body(xo);
}


static void
vch_edit(vch, item, echo)
  VCH *vch;
  int item;		/* vlist X */
  int echo;
{
  int num, row;
  char ans[8], buf[80];

  clear();

  row = 3;

  if (echo == DOECHO)	/* usWɤ~MwO_L */
    vch->vgamble = (vget(++row, 0, "O_L(Y/N)H[N] ", ans, 3, LCECHO) == 'y') ? '$' : ' ';

  if (vch->vgamble == ' ')
  {
    sprintf(buf, "аݨCH̦hiXH([1]%d)G", item);
    vget(++row, 0, buf, ans, 3, DOECHO);
    num = atoi(ans);
    if (num < 1)
      num = 1;
    else if (num > item)
      num = item;
    vch->maxblt = num;
  }
  else if (echo == DOECHO)	/* usWɤ~ܽL */
  {
    /* LNu@ */
    vch->maxblt = 1;

    vget(++row, 0, "аݨChֻȹH(100100000)G", ans, 7, DOECHO);
    num = atoi(ans);
    if (num < 100)
      num = 100;
    else if (num > 100000)
      num = 100000;
    vch->price = num;
  }

  vget(++row, 0, "벼iXp (ܤ֤@p)H[1] ", ans, 5, DOECHO);
  num = atoi(ans);
  if (num < 1)
    num = 1;
  vch->vclose = vch->chrono + num * 3600;
  str_stamp(vch->cdate, &vch->vclose);

  if (vch->vgamble == ' ')	/* L@wƧǡBܦʤ */
  {
    vch->vsort = (vget(++row, 0, "}GO_Ƨ(Y/N)H[N] ", ans, 3, LCECHO) == 'y') ? 's' : ' ';
    vch->vpercent = (vget(++row, 0, "}GO_ܦʤ(Y/N)H[N] ", ans, 3, LCECHO) == 'y') ? '%' : ' ';
  }
  else
  {
    vch->vsort = 's';
    vch->vpercent = '%';
  }

  vch->vprivate = (vget(++row, 0, "O_벼W(Y/N)H[N] ", ans, 3, LCECHO) == 'y') ? ')' : ' ';

  if (vch->vprivate == ' ' && vget(++row, 0, "O_벼(Y/N)H[N] ", ans, 3, LCECHO) == 'y')
  {
    vget(++row, 0, "аݭnnJXHW~iHѥ[벼H([0]9999)G", ans, 5, DOECHO);
    num = atoi(ans);
    if (num < 0)
      num = 0;
    vch->limitlogins = num;

    vget(++row, 0, "аݭnoXHW~iHѥ[벼H([0]9999)G", ans, 5, DOECHO);
    num = atoi(ans);
    if (num < 0)
      num = 0;
    vch->limitposts = num;
  }
}


static int
vlist_edit(vlist)
  vitem_t vlist[];
{
  int item;
  char buf[80];

  clear();

  outs("Ш̧ǿJﶵ (̦h 32 )A ENTER G");

  strcpy(buf, " ) ");
  for (;;)
  {
    item = 0;
    for (;;)
    {
      buf[0] = radix32[item];
      if (!vget((item & 15) + 3, (item / 16) * 40, buf, vlist[item], sizeof(vitem_t), GCARRY) || 
        (++item >= MAX_CHOICES))
	break;
    }
    if (item && vans("O_sJﶵ(Y/N)H[N] ") != 'y')
      break;
  }
  return item;
}


static int
vlog_seek(fpath)
  char *fpath;
{
  VLOG old;
  int fd;
  int rc = 0;

  if ((fd = open(fpath, O_RDONLY)) >= 0)
  {
    while (read(fd, &old, sizeof(VLOG)) == sizeof(VLOG))
    {
      if (!strcmp(old.userid, cuser.userid))
      {
	rc = 1;
	break;
      }
    }
    close(fd);
  }
  return rc;
}


static int
vote_add(xo)
  XO *xo;
{
  VCH vch;
  int fd, item;
  char *dir, *str, fpath[64], title[TTLEN + 1];
  vitem_t vlist[MAX_CHOICES];
  BRD *brd;

  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  if (!vget(b_lines, 0, "DG", title, TTLEN + 1, DOECHO))
    return xo->max ? XO_FOOT : vote_body(xo);	/* itoc.011125: pGS벼An^ vote_body() */
    /* return XO_FOOT; */

  dir = xo->dir;
  if ((fd = hdr_stamp(dir, 0, (HDR *) &vch, fpath)) < 0)
  {
    vmsg("Lkإߧ벼");
    return XO_FOOT;
  }

  close(fd);
  vmsg("}ls [벼]");
  fd = vedit(fpath, 0); /* Thor.981020: `NQtalkD */
  if (fd)
  {
    unlink(fpath);
    vmsg("벼");
    return vote_head(xo);
  }

  strcpy(vch.title, title);
  str = strrchr(fpath, '@');

  /* --------------------------------------------------- */
  /* 벼ﶵ : Item					 */
  /* --------------------------------------------------- */

  memset(vlist, 0, sizeof(vlist));
  item = vlist_edit(vlist);

  *str = 'I';
  if ((fd = open(fpath, O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0)
  {
    vmsg("Lkإߧ벼ﶵ");
    return vote_head(xo);
  }
  write(fd, vlist, item * sizeof(vitem_t));
  close(fd);

  vch_edit(&vch, item, DOECHO);

  strcpy(vch.owner, cuser.userid);

  brd = bshm->bcache + currbno;

  brd->bvote++;
  if (brd->bvote >= 0)
    brd->bvote = (vch.vgamble == '$') ? -1 : 1;
  vch.bstamp = brd->bstamp;

  rec_add(dir, &vch, sizeof(VCH));

  vmsg("}l벼FI");
  return vote_init(xo);
}


static int
vote_edit(xo)
  XO *xo;
{
  int pos;
  VCH *vch, vxx;
  char *dir, fpath[64];

  /* Thor: for ק벼ﶵ */
  int fd, item;
  vitem_t vlist[MAX_CHOICES];
  char *fname;

  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  pos = xo->pos;
  dir = xo->dir;
  vch = (VCH *) xo_pool + (pos - xo->top);

  /* Thor: ק벼DD */

  vxx = *vch;

  if (!vget(b_lines, 0, "DG", vxx.title, TTLEN + 1, GCARRY))
    return XO_FOOT;

  fname = vch_fpath(fpath, dir, vch);
  vedit(fpath, 0);	/* Thor.981020: `NQtalkD  */

  /* Thor: ק벼ﶵ */

  memset(vlist, 0, sizeof(vlist));
  *fname = 'I';
  if ((fd = open(fpath, O_RDONLY)) >= 0)
  {
    read(fd, vlist, sizeof(vlist));
    close(fd);
  }

  item = vlist_edit(vlist);

  if ((fd = open(fpath, O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0)
  {
    vmsg("Lkإߧ벼ﶵ");
    return vote_head(xo);
  }
  write(fd, vlist, item * sizeof(vitem_t));
  close(fd);

  vch_edit(&vxx, item, GCARRY);

  if (memcmp(&vxx, vch, sizeof(VCH)))
  {
    if (vans("Twnקo벼(Y/N)H[N] ") == 'y')
    {
      *vch = vxx;
      currchrono = vch->chrono;
      rec_put(dir, vch, sizeof(VCH), pos, cmpchrono);
    }
  }

  return vote_head(xo);
}


static int
vote_query(xo)
  XO *xo;
{
  char *dir, *fname, fpath[64], buf[80];
  VCH *vch;
  int cc, pos;

  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  pos = xo->pos;
  dir = xo->dir;
  vch = (VCH *) xo_pool + (pos - xo->top);

  fname = vch_fpath(fpath, dir, vch);
  more(fpath, (char *) -1);

  *fname = 'G';
  sprintf(buf, "@ %d Hѥ[벼ATwnN}ɶ(Y/N)H[N] ", rec_num(fpath, sizeof(VLOG)));
  if (vans(buf) == 'y')
  {
    vget(b_lines, 0, "Ч}ɶ(-nenp/+mmp/0)G", buf, 5, DOECHO);
    if (cc = atoi(buf))
    {
      vch->vclose = vch->vclose + cc * 3600;
      str_stamp(vch->cdate, &vch->vclose);
      currchrono = vch->chrono;
      rec_put(dir, vch, sizeof(VCH), pos, cmpchrono);
    }
  }

  return vote_head(xo); 
}


static int
vfyvch(vch, pos)
  VCH *vch;
  int pos;
{
  return Tagger(vch->chrono, pos, TAG_NIN);
}


static void
delvch(xo, vch)
  XO *xo;
  VCH *vch;
{
  int fd;
  char fpath[64], buf[64], *fname;
  char *list = "@IOLGZ";	/* itoc.: M vote file */
  VLOG vlog;
  PAYCHECK paycheck;

  fname = vch_fpath(fpath, xo->dir, vch);

  if (vch->vgamble == '$')	/* itoc.050313: pGOLQRAnh */
  {
    *fname = 'G';

    if ((fd = open(fpath, O_RDONLY)) >= 0)
    {
      memset(&paycheck, 0, sizeof(PAYCHECK));
      time(&paycheck.tissue);
      sprintf(paycheck.reason, "[h] %s", currboard);

      while (read(fd, &vlog, sizeof(VLOG)) == sizeof(VLOG))
      {
	paycheck.money = vlog.numvotes * vch->price;
	usr_fpath(buf, vlog.userid, FN_PAYCHECK);
	rec_add(buf, &paycheck, sizeof(PAYCHECK));
      }
    }
    close(fd);
  }

  while (*fname = *list++)
    unlink(fpath); /* Thor: TwWrN */
}



static int
vote_delete(xo)
  XO *xo;
{
  int pos;
  VCH *vch;

  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  pos = xo->pos;
  vch = (VCH *) xo_pool + (pos - xo->top);

  if (vans(msg_del_ny) == 'y')
  {
    delvch(xo, vch);

    currchrono = vch->chrono;
    rec_del(xo->dir, sizeof(VCH), pos, cmpchrono);    
    return vote_load(xo);
  }

  return XO_FOOT;
}


static int
vote_rangedel(xo)
  XO *xo;
{
  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  return xo_rangedel(xo, sizeof(VCH), NULL, delvch);
}


static int
vote_prune(xo)
  XO *xo;
{
  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  return xo_prune(xo, sizeof(VCH), vfyvch, delvch);
}


static int
vote_pal(xo)		/* itoc.020117: s譭벼W */
  XO *xo;
{
  char *fname, fpath[64];
  VCH *vch;
  XO *xt;

  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  vch = (VCH *) xo_pool + (xo->pos - xo->top);

  if (vch->vprivate != ')')
    return XO_NONE;

  fname = vch_fpath(fpath, xo->dir, vch);
  *fname = 'L';

  xz[XZ_PAL - XO_ZONE].xo = xt = xo_new(fpath);
  xt->key = PALTYPE_VOTE;
  xover(XZ_PAL);		/* Thor: ixovere, pal_xo @wn ready */

  free(xt);
  return vote_init(xo);
}


static int
vote_join(xo)
  XO *xo;
{
  VCH *vch, vbuf;
  VLOG vlog;
  int count, fd;
  usint choice;
  char *dir, *fname, fpath[64], buf[80], ans[4], *slist[MAX_CHOICES];
  vitem_t vlist[MAX_CHOICES];

  if (HAS_STATUS(STATUS_COINLOCK))
  {
    vmsg(msg_coinlock);
    return XO_FOOT;
  }

  vch = (VCH *) xo_pool + (xo->pos - xo->top);

  /* --------------------------------------------------- */
  /* ˬdO_wg벼				 */
  /* --------------------------------------------------- */

  if (time(0) > vch->vclose)
  {
    vmsg("벼wgIFARԶ}");
    return XO_FOOT;
  }

  /* --------------------------------------------------- */
  /* ˬdO_					 */
  /* --------------------------------------------------- */

  if (vch->vgamble == '$')
  {
    if (cuser.money < vch->price)
    {
      vmsg("zѥ[L");
      return XO_FOOT;
    }
  }

  /* --------------------------------------------------- */
  /* 벼ɮ						 */
  /* --------------------------------------------------- */

  dir = xo->dir;
  fname = vch_fpath(fpath, dir, vch);

  /* --------------------------------------------------- */
  /* ˬdO_wgL					 */
  /* --------------------------------------------------- */

  if (vch->vgamble == ' ')	/* itoc.031101: LiH@U` */
  {
    *fname = 'G';
    if (vlog_seek(fpath))
    {
      vmsg("zwgLFI");
      return XO_FOOT;
    }
  }

  /* --------------------------------------------------- */
  /* ˬd벼					 */
  /* --------------------------------------------------- */

  if (vch->vprivate == ' ')
  {
    if (cuser.numlogins < vch->limitlogins || cuser.numposts < vch->limitposts)
    {
      vmsg("z`I");
      return XO_FOOT;
    }
  }
  else		/* itoc.020117: pH벼ˬdO_b벼W椤 */
  {
    *fname = 'L';

    if (!pal_find(fpath, cuser.userno) &&
      !(bbstate & STAT_BOARD))		/* ѩäۤv[JBͦWAҥHnhˬdO_OD */
    {
      vmsg("zSܥpH벼I");
      return XO_FOOT;
    }
  }

  /* --------------------------------------------------- */
  /* T{iJ벼					 */
  /* --------------------------------------------------- */

  if (vans(vch->vgamble == ' ' ? "O_ѥ[벼(Y/N)H[N] " : "O_ѥ[L(Y/N)H[N] ") != 'y')
    return XO_FOOT;

  /* --------------------------------------------------- */
  /* }l벼Aܧ벼				 */
  /* --------------------------------------------------- */

  *fname = '@';
  more(fpath, NULL);

  /* --------------------------------------------------- */
  /* J벼ﶵ					 */
  /* --------------------------------------------------- */

  *fname = 'I';
  if ((fd = open(fpath, O_RDONLY)) < 0)
  {
    vmsg("LkŪ벼ﶵ");
    return vote_head(xo);
  }
  count = read(fd, vlist, sizeof(vlist)) / sizeof(vitem_t);
  close(fd);

  for (fd = 0; fd < count; fd++)
    slist[fd] = (char *) &vlist[fd];

  /* --------------------------------------------------- */
  /* i벼						 */
  /* --------------------------------------------------- */

  choice = 0;
  sprintf(buf, "Ut %d ", vch->maxblt); /* Thor: ̦ܳhX */
  vs_bar(buf);
  outs("벼DDG");
  for (;;)
  {
    choice = bitset(choice, count, vch->maxblt, vch->title, slist);

    if (vch->vgamble == ' ')		/* @벼~gN */
      vget(b_lines - 1, 0, "ڦܭnG", buf, 60, DOECHO);

    fd = vans("벼 (Y)Tw (N) (Q)H[N] ");

    if (fd == 'q')
      return vote_head(xo);

    if ((fd == 'y') && (vch->vgamble == ' ' || choice))	/* YOLh@wn */
      break;
  }

  /* --------------------------------------------------- */
  /* OGG@]몺p ==> ۷o	 */
  /* --------------------------------------------------- */

  if (vch->vgamble == '$')
  {
    /* LiHRJhi */
    for (;;)
    {
      sprintf(buf, "Ci䲼 %d ȹAаݭnRXiH[1] ", vch->price);
      vget(b_lines, 0, buf, ans, 3, DOECHO);	/* ̦hR 99 iAקK */

      if (time(0) > vch->vclose)	/* ] vgetAҥH٭nAˬd@ */
      {
	vmsg("벼wgIFARԶ}");
	return vote_head(xo);
      }

      if ((count = atoi(ans)) < 1)
	count = 1;
      fd = count * vch->price;
      if (cuser.money >= fd)
	break;
    }
  }
  else
  {
    /* @벼NO@i */
    count = 1;
  }

  /* Tw벼|I */
  /* itoc.050514: ]ODiHܶ}ɶAFקKϥΪ̷|tb vget() άO
     Q xo_pool[] PBӳW time(0) > vclose ˬdAҥHNosJ VCH */
  if (rec_get(dir, &vbuf, sizeof(VCH), xo->pos) || vch->chrono != vch->chrono || time(0) > vbuf.vclose)
  {
    vmsg("벼wgIFARԶ}");
    return vote_init(xo);
  }

  if (vch->vgamble == '$')
  {
    cuser.money -= fd;	/* fd OnI */
  }
  else if (*buf)	/* @벼~gJϥΪ̷N */
  {
    FILE *fp;

    *fname = 'O';
    if (fp = fopen(fpath, "a"))
    {
      fprintf(fp, "E%-12sG%s\n", cuser.userid, buf);
      fclose(fp);
    }
  }

  /* [JO */
  memset(&vlog, 0, sizeof(VLOG));
  strcpy(vlog.userid, cuser.userid);
  vlog.numvotes = count;
  vlog.choice = choice;
  *fname = 'G';
  rec_add(fpath, &vlog, sizeof(VLOG));

  vmsg("벼I");
  return vote_head(xo);
}


struct Tchoice
{
  int count;
  vitem_t vitem;
};


static int
TchoiceCompare(i, j)
  struct Tchoice *i, *j;
{
  return j->count - i->count;
}


static char *			/* NULL:(٨SH벼) */
draw_vote(fpath, folder, vch, preview)	/* itoc.030906: 벼G (P account.c:draw_vote() 榡ۦP) */
  char *fpath;
  char *folder;
  VCH *vch;
  int preview;		/* 1:w 0:} */
{
  struct Tchoice choice[MAX_CHOICES];
  FILE *fp;
  char *fname;
  int total, items, num, fd, ticket, bollt;
  VLOG vlog;

  fname = vch_fpath(fpath, folder, vch);

  /* vote item */

  *fname = 'I';

  items = 0;
  if (fp = fopen(fpath, "r"))
  {
    while (fread(&choice[items].vitem, sizeof(vitem_t), 1, fp) == 1)
    {
      choice[items].count = 0;
      items++;
    }
    fclose(fp);
  }

  if (items == 0)
    return NULL;

  /* ֭p벼G */

  *fname = 'G';
  bollt = 0;		/* Thor: `ks */
  total = 0;

  if ((fd = open(fpath, O_RDONLY)) >= 0)
  {
    while (read(fd, &vlog, sizeof(VLOG)) == sizeof(VLOG))
    {
      for (ticket = vlog.choice, num = 0; ticket && num < items; ticket >>= 1, num++)
      {
	if (ticket & 1)
	{
	  choice[num].count += vlog.numvotes;
	  bollt += vlog.numvotes;
	}
      }
      total++;
    }
    close(fd);
  }

  /* Ͷ}G */

  *fname = 'Z';
  if (!(fp = fopen(fpath, "w")))
    return NULL;

  fprintf(fp, "\n\033[1;34m%s\033[m\n\n"
    "\033[1;32m [%s] ݪO벼G%s\033[m\n\n|ODG%s\n\n|G%s\n\n",
    msg_seperator, currboard, vch->title, vch->owner, Btime(&vch->chrono));
  fprintf(fp, "}G%s\n\n\033[1;32m 벼DDG\033[m\n\n", Btime(&vch->vclose));

  *fname = '@';
  f_suck(fp, fpath);

  fprintf(fp, "\n\033[1;32m 벼GGCHi %d A@ %d Hѥ[AX %d \033[m\n\n",
    vch->maxblt, total, bollt);

  if (vch->vsort == 's')
    qsort(choice, items, sizeof(struct Tchoice), TchoiceCompare);

  if (vch->vpercent == '%')
    fd = BMAX(1, bollt);
  else
    fd = 0;

  if (preview && vch->vgamble == ' ')	/* uwL~ݭn߲ܽv */
    preview = 0;

  for (num = 0; num < items; num++)
  {
    ticket = choice[num].count;
    if (preview)	/* ܥ[R@iɪ߲v */
      fprintf(fp, "    %-36s%5d  (%4.1f%%) ߲v 1:%.3f\n", &choice[num].vitem, ticket, 100.0 * ticket / fd, 0.9 * (bollt + 1) / (ticket + 1));
    else if (fd)
      fprintf(fp, "    %-36s%5d  (%4.1f%%)\n", &choice[num].vitem, ticket, 100.0 * ticket / fd);
    else
      fprintf(fp, "    %-36s%5d \n", &choice[num].vitem, ticket);
  }

  /* other opinions */

  *fname = 'O';
  fputs("\n\033[1;32m ڦܭnG\033[m\n\n", fp);
  f_suck(fp, fpath);
  fputs("\n", fp);
  fclose(fp);

  /* ̫Ǧ^ fpath Y벼G */
  *fname = 'Z';
  return fname;
}


static int
vote_view(xo)
  XO *xo;
{
  char fpath[64];
  VCH *vch;

  vch = (VCH *) xo_pool + (xo->pos - xo->top);

  if (bbstate & STAT_BOARD || vch->vgamble == '$')
  {
    if (draw_vote(fpath, xo->dir, vch, 1))
    {
      more(fpath, NULL);
      unlink(fpath);
      return vote_head(xo);
    }

    vmsg("ثe|H벼");
    return XO_FOOT;
  }

  return XO_NONE;
}


static void
keeplog(fnlog, board, title)
  char *fnlog;
  char *board;
  char *title;
{
  HDR hdr;
  char folder[64], fpath[64];
  FILE *fp;

  if (!dashf(fnlog))	/* Kudo.010804: ɮ׬OŪN keeplog */
    return;

  brd_fpath(folder, board, fn_dir);

  if (fp = fdopen(hdr_stamp(folder, 'A', &hdr, fpath), "w"))
  {
    fprintf(fp, "@: %s (%s)\nD: %s\nɶ: %s\n\n",
      str_sysop, SYSOPNICK, title, Btime(&hdr.chrono));
    f_suck(fp, fnlog);
    fclose(fp);

    strcpy(hdr.title, title);
    strcpy(hdr.owner, str_sysop);
    rec_bot(folder, &hdr, sizeof(HDR));

    btime_update(brd_bno(board));
  }
}


static void
vlog_pay(fpath, choice, fp, vch)/* ߿諸ϥΪ */
  char *fpath;			/* Oɸ| */
  usint choice;			/* T */
  FILE *fp;			/* gJɮ */
  VCH *vch;
{
  int fd;
  int correct, bollt;		/* /  */
  int single, money;
  char buf[64];
  VLOG vlog;
  PAYCHECK paycheck;

  if ((fd = open(fpath, O_RDONLY)) >= 0)
  {
    /* Ĥ@X߲v */
    correct = bollt = 0;
    while (read(fd, &vlog, sizeof(VLOG)) == sizeof(VLOG))
    {
      bollt += vlog.numvotes;
      if (vlog.choice == choice)
	correct += vlog.numvotes;
    }

    /* ODY 1% */
    money = (INT_MAX / vch->price) * 100;	/* BioStar.050626: קK */
    money = (bollt > money) ? INT_MAX : vch->price / 100 * bollt;
    fprintf(fp, "OD %s YAio %d ȹ\n", vch->owner, money);

    memset(&paycheck, 0, sizeof(PAYCHECK));
    time(&paycheck.tissue);
    paycheck.money = money;
    sprintf(paycheck.reason, "[Y] %s", currboard);
    usr_fpath(buf, vch->owner, FN_PAYCHECK);
    rec_add(buf, &paycheck, sizeof(PAYCHECK));

    if (correct)	/* pGSH㤤ANݭno */
    {
      /* oAtΩ 10% | */
      single = (float) vch->price * 0.9 * bollt / correct;
      fprintf(fp, "Cii %d ȹA諸ϥΪ̦G\n", single);

      /* ĤG}lo */
      lseek(fd, (off_t) 0, SEEK_SET);
      while (read(fd, &vlog, sizeof(VLOG)) == sizeof(VLOG))
      {
	if (vlog.choice == choice)
	{
	  money = INT_MAX / single;		/* BioStar.050626: קK */
	  money = (vlog.numvotes > money) ? INT_MAX : single * vlog.numvotes;
	  fprintf(fp, "%s RF %d iA@io %d ȹ\n", vlog.userid, vlog.numvotes, money);

	  paycheck.money = money;
	  sprintf(paycheck.reason, "[L] %s", currboard);
	  usr_fpath(buf, vlog.userid, FN_PAYCHECK);
	  rec_add(buf, &paycheck, sizeof(PAYCHECK));
	}
      }
    }

    close(fd);
  }
}


static int
vote_open(xo)
  XO *xo;
{
  int pos, fd, count;
  char *dir, *fname, fpath[64], buf[80];
  usint choice;
  char *slist[MAX_CHOICES];
  vitem_t vlist[MAX_CHOICES];
  VCH *vch;
  FILE *fp;

  if (!(bbstate & STAT_BOARD))
    return XO_NONE;

  pos = xo->pos;
  vch = (VCH *) xo_pool + (pos - xo->top);

  if (time(NULL) < vch->vclose)
  {
    if (vans("|w}ɶATwn}(Y/N)H[N] ") != 'y')
      return XO_FOOT;
  }

  dir = xo->dir;

  /* 벼G */

  if (!(fname = draw_vote(fpath, dir, vch, 0)))
  {
    vmsg("ثe|H벼");
    return XO_FOOT;
  }

  if (vch->vgamble == '$')	/* L */
  {
    /* ODJGAügJ벼G */
    while (!vget(b_lines, 0, "пJTסG", buf, 60, DOECHO))
      ;

    /* J벼ﶵ */
    *fname = 'I';
    if ((fd = open(fpath, O_RDONLY)) >= 0)
    {
      count = read(fd, vlist, sizeof(vlist)) / sizeof(vitem_t);
      close(fd);

      for (fd = 0; fd < count; fd++)
	slist[fd] = (char *) &vlist[fd];

      /* ODXT */
      choice = 0;
      vs_bar("ܥT");
      outs("벼DDG");
      for (;;)
      {
	choice = bitset(choice, count, vch->maxblt, vch->title, slist);

	fd = vans("} (Y)Tw (N) (Q)H[N] ");

	if (fd == 'q')
	{
	  *fname = 'Z';
	  unlink(fpath);
	  return vote_head(xo);
	}

	if (fd == 'y' && choice)	/* YOLh@wn */
	  break;
      }

      /* }lo */
      *fname = 'Z';
      if (fp = fopen(fpath, "a"))
      {
	fprintf(fp, "ODGסG%s\n\n", buf);

	*fname = 'G';
	vlog_pay(fpath, choice, fp, vch);

	fputs("\n", fp);
	fclose(fp);
      }

      /* }G */
      *fname = 'Z';
    }
  }

  /* N}G post  [BN_RECORD] P ݪO */

  if (!(currbattr & BRD_NOVOTE))
  {
    sprintf(buf, "[O] %s <<ݪOﱡ>>", currboard);
    keeplog(fpath, BN_RECORD, buf);
  }

  keeplog(fpath, currboard, "[O] ﱡ");

  /* 벼G[ @vote */

  setdirpath(buf, dir, "@/@vote");
  if (fp = fopen(fpath, "a"))
  {
    f_suck(fp, buf);
    fclose(fp);
    rename(fpath, buf);
  }

  /* }NR */
  vch->vgamble = ' ';	/* ODLApb delvch ̭N|h */
  delvch(xo, vch);

  currchrono = vch->chrono;
  rec_del(dir, sizeof(VCH), pos, cmpchrono);    

  vmsg("}");
  return vote_init(xo);
}


static int
vote_tag(xo)
  XO *xo;
{
  VCH *vch;
  int tag, pos, cur;

  pos = xo->pos;
  cur = pos - xo->top;
  vch = (VCH *) xo_pool + cur;

  if (tag = Tagger(vch->chrono, pos, TAG_TOGGLE))
  {
    move(3 + cur, 6);
    outc(tag > 0 ? '*' : ' ');
  }

  /* return XO_NONE; */
  return xo->pos + 1 + XO_MOVE;	/* lkchu.981201: ܤU@ */
}


static int
vote_help(xo)
  XO *xo;
{
  xo_help("vote");
  return vote_head(xo);
}


static KeyFunc vote_cb[] =
{
  XO_INIT, vote_init,
  XO_LOAD, vote_load,
  XO_HEAD, vote_head,
  XO_BODY, vote_body,

  'r', vote_join,	/* itoc.010901: kK */
  'v', vote_join,
  'R', vote_result,

  'V', vote_view,
  'E', vote_edit,
  'o', vote_pal,
  'd', vote_delete,
  'D', vote_rangedel,
  't', vote_tag,
  'b', vote_open,

  Ctrl('D'), vote_prune,
  Ctrl('G'), vote_pal,
  Ctrl('P'), vote_add,
  Ctrl('Q'), vote_query,

  'h', vote_help
};


int
XoVote(xo)
  XO *xo;
{
  char fpath[64];

  /*  post vQ~ѥ[벼 */
  /* ӥBnקK guest b sysop O벼 */

  if (!(bbstate & STAT_POST) || !cuser.userlevel)
    return XO_NONE;

  setdirpath(fpath, xo->dir, FN_VCH);
  if (!(bbstate & STAT_BOARD) && !rec_num(fpath, sizeof(VCH)))
  {
    vmsg("ثeS벼|");
    return XO_FOOT;
  }

  xz[XZ_VOTE - XO_ZONE].xo = xo = xo_new(fpath);
  xz[XZ_VOTE - XO_ZONE].cb = vote_cb;
  xover(XZ_VOTE);
  free(xo);

  return XO_INIT;
}


int
vote_all()		/* itoc.010414: 벼 */
{
  typedef struct
  {
    char brdname[BNLEN + 1];
    char class[BCLEN + 1];
    char title[BTLEN + 1];
    char BM[BMLEN + 1];
    char bvote;
  } vbrd_t;

  extern char brd_bits[];
  char *str;
  char fpath[64];
  int num, pageno, pagemax, redraw;
  int ch, cur;
  BRD *bhead, *btail;
  XO *xo;
  vbrd_t vbrd[MAXBOARD], *vb;

  bhead = bshm->bcache;
  btail = bhead + bshm->number;
  cur = 0;
  num = 0;

  do
  {
    str = &brd_bits[cur];
    ch = *str;
    if (bhead->bvote && (ch & BRD_W_BIT))
    {
      vb = vbrd + num;
      strcpy(vb->brdname, bhead->brdname);
      strcpy(vb->class, bhead->class);
      strcpy(vb->title, bhead->title);
      strcpy(vb->BM, bhead->BM);
      vb->bvote = bhead->bvote;
      num++;
    }
    cur++;
  } while (++bhead < btail);

  if (!num)
  {
    vmsg("ثeèS벼");
    return XEASY;
  }

  num--;
  pagemax = num / XO_TALL;
  pageno = 0;
  cur = 0;
  redraw = 1;

  do
  {
    if (redraw)
    {
      /* itoc.: ɶqo xover 榡 */
      vs_head("벼", str_site);
      prints(NECKER_VOTEALL, d_cols >> 1, "", d_cols - (d_cols >> 1), "");

      redraw = pageno * XO_TALL;	/* ɥ redraw */
      ch = BMIN(num, redraw + XO_TALL - 1);
      move(3, 0);
      do
      {
	vb = vbrd + redraw;
	/* itoc.010909: OWӪRB[CC] BCLEN = 4 */
	prints("%6d   %-13s\033[1;3%dm%-5s\033[m%s %-*.*s %.*s\n",
	  redraw + 1, vb->brdname,
	  vb->class[3] & 7, vb->class,
	  vb->bvote > 0 ? ICON_VOTED_BRD : ICON_GAMBLED_BRD,
	  (d_cols >> 1) + 34, (d_cols >> 1) + 33, vb->title, d_cols - (d_cols >> 1) + 13, vb->BM);

	redraw++;
      } while (redraw <= ch);

      outf(FEETER_VOTEALL);
      move(3 + cur, 0);
      outc('>');
      redraw = 0;
    }

    switch (ch = vkey())
    {
    case KEY_RIGHT:
    case '\n':
    case ' ':
    case 'r':
      vb = vbrd + (cur + pageno * XO_TALL);

      /* itoc.060324: PiJsݪOAXoPost() ơAo̴XGn */
      if (!vb->brdname[0])	/* wRݪO */
	break;

      redraw = brd_bno(vb->brdname);	/* ɥ redraw */
      if (currbno != redraw)
      {
	ch = brd_bits[redraw];

	/* Bzv */
	if (ch & BRD_M_BIT)
	  bbstate |= (STAT_BM | STAT_BOARD | STAT_POST);
	else if (ch & BRD_X_BIT)
	  bbstate |= (STAT_BOARD | STAT_POST);
	else if (ch & BRD_W_BIT)
	  bbstate |= STAT_POST;

	mantime_add(currbno, redraw);

	currbno = redraw;
	bhead = bshm->bcache + currbno;
	currbattr = bhead->battr;
	strcpy(currboard, bhead->brdname);
	str = bhead->BM;
	sprintf(currBM, "ODG%s", *str <= ' ' ? "xD" : str);
#ifdef HAVE_BRDMATE
	strcpy(cutmp->reading, currboard);
#endif

	brd_fpath(fpath, currboard, fn_dir);
#ifdef AUTO_JUMPPOST
	xz[XZ_POST - XO_ZONE].xo = xo = xo_get_post(fpath, bhead);	/* itoc.010910:  XoPost qy@ xo_get() */
#else
	xz[XZ_POST - XO_ZONE].xo = xo = xo_get(fpath);
#endif
	xo->key = XZ_POST;
	xo->xyz = bhead->title;
      }

      sprintf(fpath, "brd/%s/%s", currboard, FN_VCH);
      xz[XZ_VOTE - XO_ZONE].xo = xo = xo_new(fpath);
      xz[XZ_VOTE - XO_ZONE].cb = vote_cb;
      xover(XZ_VOTE);
      free(xo);
      redraw = 1;
      break;

    default:
      ch = xo_cursor(ch, pagemax, num, &pageno, &cur, &redraw);
      break;
    }
  } while (ch != 'q');

  return 0;
}
