/*-------------------------------------------------------*/
/* window.c	( NTHU CS MapleBBS Ver 3.10 )		 */
/*-------------------------------------------------------*/
/* target : popup window menu				 */
/* create : 03/02/12					 */
/* update : 03/07/23					 */
/* author : verit.bbs@bbs.yzu.edu.tw			 */
/* modify : itoc.bbs@bbs.tnfsh.tn.edu.tw		 */
/*-------------------------------------------------------*/


#include "bbs.h"

#ifdef HAVE_POPUPMENU

static screenline slt[T_LINES];
static int x_roll;


/* ----------------------------------------------------- */
/* eøs						 */
/* ----------------------------------------------------- */


static void
draw_line(x, y, msg)	/* b (x, y) mJ msgAknLXӪmr */
  int x, y;
  uschar *msg;
{
  uschar *str, *ptr;
  uschar data[ANSILINELEN];
  char color[4];
  int ch, i;
  int len;
  int ansi;		/* 1: b ANSI  */
  int in_chi = 0;	/* 1: br */
  int fg, bg, hl;	/* e/I/m */

  hl = 0;
  fg = 37;
  bg = 40;

  i = x + x_roll;
  if (i > b_lines)
    i -= b_lines + 1;

  memset(data, 0, sizeof(data));
  strncpy(data, slt[i].data, slt[i].len);
  str = data;
  
  move(x, 0);
  clrtoeol();

  /* LX (x, 0)  (x, y - 1) */
  ansi = 0;
  len = 0;		/* wLXXӦr (tX) */
  while (ch = *str++)
  {
    if (ch == KEY_ESC)
    {
      ansi = 1;
      i = 0;
    }
    else if (ansi)
    {
      if (ch == '[')
      {
      }
      else if (ch >= '0' && ch <= '9')
      {
	color[i] = ch;
	if (++i >= 4)
	  i = 0;
      }
      else
      {
	color[i] = 0;

	i = atoi(color);
	if (i == 0)
	{
	  hl = 0;
	  fg = 37;
	  bg = 40;
	}
	else if (i == 1)
	  hl = 1;
	else if (i >= 30 && i <= 37)
	  fg = i;
	else if (i >= 40 && i <= 47)
	  bg = i;

	i = 0;

	if (ch != ';')
	  ansi = 0;
      }
    }
    else
    {
      if (++len >= y)
      {
	/* ̫@rYOrXANL */
	if (!in_chi && IS_ZHC_HI(ch))
	{
	  outc(' ');
	  in_chi ^= 1;
	}
	else
	{
	  outc(ch);
	  in_chi = 0;
	}
	outs(str_ransi);
	break;
      }

      if (in_chi || IS_ZHC_HI(ch))
	in_chi ^= 1;
    }

    outc(ch);
  }
  while (len++ < y)
    outc(' ');

  /* LX (x, y)  (x, y + strip_ansi_len(msg) - 1) */
  ptr = msg;
  ansi = 0;
  len = 0;		/* msg (tX) */
  while (ch = *ptr++)
  {
    if (ch == KEY_ESC)
    {
      ansi = 1;
    }
    else if (ansi)
    {
      if ((ch < '0' || ch > '9') && ch != ';' && ch != '[')
	ansi = 0;
    }
    else
    {
      len++;
    }
    outc(ch);
  }

  /*  str @qAèX̫᪺C */
  ansi = 0;
  while (ch = *str++)
  {
    if (ch == KEY_ESC)
    {
      ansi = 1;
      i = 0;
    }
    else if (ansi)
    {
      if (ch == '[')
	continue;
      if (ch >= '0' && ch <= '9')
      {
	color[i] = ch;
	if (++i >= 4)
	  i = 0;
      }
      else
      {
	color[i] = 0;

	i = atoi(color);
	if (i == 0)
	{
	  hl = 0;
	  fg = 37;
	  bg = 40;
	}
	else if (i == 1)
	  hl = 1;
	else if (i >= 30 && i <= 37)
	  fg = i;
	else if (i >= 40 && i <= 47)
	  bg = i;

	i = 0;

	if (ch != ';')
	  ansi = 0;
      }
    }
    else
    {
      if (--len < 0)	/* L strip_ansi_len(msg)  */
	break;

      if (in_chi || IS_ZHC_HI(ch))
	in_chi ^= 1;
    }
  }

  /* LX (x, y + strip_ansi_len(msg)) oӦrΫ᭱X */
  prints("\033[%d;%d;%dm", hl, fg, bg);
  /* rYOrXANL */
  outc(in_chi ? ' ' : ch);

  /* LX (x, y + strip_ansi_len(msg) + 1)   */
  outs(str);
  outs(str_ransi);
}


#ifdef POPUP_ANSWER

/* ----------------------------------------------------- */
/* ﶵøs						 */
/* ----------------------------------------------------- */


static int
draw_item(x, y, desc, hotkey, mode)
  int x, y;
  char *desc;
  char hotkey;
  int mode;		/* 0:M  1:eW */
{
  char buf[128];

  sprintf(buf, " x%s%c %c%c%c%-25s  \033[mx ",
    mode ? COLOR4 : "\033[30;47m", mode ? '>' : ' ',
    (hotkey == *desc) ? '[' : '(', *desc,
    (hotkey == *desc) ? ']' : ')', desc + 1);

  draw_line(x, y, buf);
}


static int	/* ^`@Xӿﶵ */
draw_menu(x, y, title, desc, hotkey, cur)
  int x, y;
  char *title;
  char *desc[];
  char hotkey;
  int *cur;	/* ^ǹw]ȩҦbm */
{
  int i, meet;
  char buf[128];

  draw_line(x++, y, " ~wwwwwwwwwwwwwwww ");

  sprintf(buf, " x" COLOR4 "  %-28s  \033[mx ", title);
  draw_line(x++, y, buf);

  draw_line(x++, y, " uwwwwwwwwwwwwwwwwt ");

  for (i = 1; desc[i]; i++)
  {
    meet = (desc[i][0] == hotkey);
    draw_item(x++, y, desc[i], hotkey, meet);
    if (meet)
      *cur = i;
  }

  draw_line(x, y, " wwwwwwwwwwwwwwww ");

  /* קKbkΤUA|Gh檺D */
  move(b_lines, 0);

  return i - 1;
}


/* ----------------------------------------------------- */
/* ﶵ						 */
/* ----------------------------------------------------- */


static int			/* -1:䤣 >=0:ĴXӿﶵ */
find_cur(ch, max, desc)		/*  ch oӫOĴXӿﶵ */
  int ch, max;
  char *desc[];
{
  int i, cc;

  if (ch >= 'A' && ch <= 'Z')
    ch |= 0x20;		/* pg */

  for (i = 1; i <= max; i++)
  {
    cc = desc[i][0];
    if (cc >= 'A' && cc <= 'Z')
      cc |= 0x20;	/* pg */

    if (ch == cc)
      return i;
  }

  return -1;
}


/*------------------------------------------------------ */
/* ߰ݿﶵAiΨӨN vans()				 */
/*------------------------------------------------------ */
/* x, y  OۥXW (x, y) m			 */
/* title OD					 */
/* desc  OﶵԭzG					 */
/*       Ĥ@Ӧrꥲ char			 */
/*         Ĥ@ӦrN@}lаm		 */
/*         ĤGӦrNU KEY_LEFT w]^ǭ	 */
/*       rOCӿﶵԭz (r)	 */
/*       ̫@Ӧrꥲ NULL			 */
/*------------------------------------------------------ */


int		/* Ǧ^pgrμƦr */
pans(x, y, title, desc)
  int x, y;
  char *title;
  char *desc[];
{
  int cur, old_cur, max, ch;
  char hotkey;

  x_roll = vs_save(slt);

  hotkey = desc[0][0];

  /* eXӿ */
  max = draw_menu(x, y, title, desc, hotkey, &cur);
  x += 2;

  /* @iJAаbw] */
  old_cur = cur;

  while (1)
  {
    switch (ch = vkey())
    {
    case KEY_LEFT:
    case KEY_RIGHT:
    case '\n':
      vs_restore(slt);
      ch = (ch == KEY_LEFT) ? desc[0][1] : desc[cur][0];
      if (ch >= 'A' && ch <= 'Z')
	ch |= 0x20;		/* ^Ǥpg */
      return ch;

    case KEY_UP:
      cur = (cur == 1) ? max : cur - 1;
      break;

    case KEY_DOWN:
      cur = (cur == max) ? 1 : cur + 1;
      break;

    case KEY_HOME:
      cur = 1;
      break;

    case KEY_END:
      cur = max;
      break;

    default:		/* hҫO@ӿﶵ */
      if ((ch = find_cur(ch, max, desc)) > 0)
	cur = ch;
      break;
    }

    if (old_cur != cur)		/* ܰʦm~ݭnø */
    {
      draw_item(x + old_cur, y, desc[old_cur], hotkey, 0);
      draw_item(x + cur, y, desc[cur], hotkey, 1);
      old_cur = cur;
      /* קKbkΤUA|Gh檺D */
      move(b_lines, 0);
    }
  }
}
#endif	/* POPUP_ANSWER */


#ifdef POPUP_MESSAGE
/*------------------------------------------------------ */
/* ۥXTAiΨӨN vmsg()			 */
/*------------------------------------------------------ */


int
pmsg(msg)
  char *msg;		/* i NULL */
{
  int len, x, y, i;
  char buf[80];

  x_roll = vs_save(slt);

  len = strlen(msg);
  if (len < 16)		/*  msg title 䤤̬ len */
    len = 16;
  if (len % 2)		/* ܦ */
    len++;
  x = (b_lines - 4) >> 1;	/* m */
  y = (b_cols - 8 - len) >> 1;

  strcpy(buf, "~");
  for (i = -4; i < len; i += 2)
    strcat(buf, "w");
  strcat(buf, "");
  draw_line(x++, y, buf);

  sprintf(buf, "x" COLOR4 "  %-*s  \033[mx", len, "ЫN~..");
  draw_line(x++, y, buf);

  strcpy(buf, "u");
  for (i = -4; i < len; i += 2)
    strcat(buf, "w");
   strcat(buf, "t");
  draw_line(x++, y, buf);

  sprintf(buf, "x\033[30;47m  %-*s  \033[mx", len, msg);
  draw_line(x++, y, buf);

  strcpy(buf, "");
  for (i = -4; i < len; i += 2)
    strcat(buf, "w");
  strcat(buf, "");
  draw_line(x++, y, buf);

  move(b_lines, 0);

  x = vkey();
  vs_restore(slt);
  return x;
}
#endif	/* POPUP_MESSAGE */

#endif	/* HAVE_POPUPMENU */
