/*-------------------------------------------------------*/
/* ulist.c	( NTHU CS MapleBBS Ver 3.00 )		 */
/*-------------------------------------------------------*/
/* target : ulist routines	 			 */
/* create : 95/03/29				 	 */
/* update : 97/03/29				 	 */
/*-------------------------------------------------------*/


#include "bbs.h"


extern UCACHE *ushm;
extern XZ xz[];


/*-------------------------------------------------------*/
/* 榡Ѥ					 */
/*-------------------------------------------------------*/


static int pickup_ship = 0;	/* 0:Gm !=0:ͽ˱ԭz */

typedef UTMP *pickup;

/* ǧYƧǪ */
#define FTYPE_SELF	0x01
#define FTYPE_BOTHGOOD	0x02
#define FTYPE_MYGOOD	0x04
#define FTYPE_OGOOD	0x08
#define FTYPE_NORMAL	0x10
#define FTYPE_MYBAD	0x20

static int mygood_num;		/* ]ڬn */
static int ogood_num;		/* ڳ]謰n */

static pickup ulist_pool[MAXACTIVE];
/* static */ int ulist_userno[MAXACTIVE];	/*  ushm U檺 userno */
static int ulist_ftype[MAXACTIVE];		/*  ushm U檺Bͺ */

static int ulist_init();
static int ulist_head();
static XO ulist_xo;


#if 0
static char *
pal_ship(ftype, userno)	/* itoc.020811: Ǧ^Bͱԭz */
  int ftype, userno;
{
  int fd;
  PAL *pal;
  char fpath[64];
  static char palship[46];

  if (ftype & (FTYPE_BOTHGOOD | FTYPE_MYGOOD | FTYPE_MYBAD))	/* ]n͡Bڪn͡BaH~ͽ˱ԭz */
  {
    usr_fpath(fpath, cuser.userid, fn_pal);
    if ((fd = open(fpath, O_RDONLY)) >= 0)
    {
      mgets(-1);
      while (pal = mread(fd, sizeof(PAL)))
      {
	if (userno == pal->userno)
	{
	  strcpy(palship, pal->ship);
	  close(fd);
	  return palship;
	}
      }
      close(fd);
    }
  }
  return "";
}
#endif


#if 1	/* itoc.020901:  cache MnAOZOO骺 */
typedef struct
{
  int userno;
  char ship[20];	/* ݭnM PAL.ship @ˤjAun ulist_body() ܧYi */
}	PALSHIP;

        
static char *
pal_ship(ftype, userno)	/* itoc.020811: Ǧ^Bͱԭz */
  int ftype, userno;
{
  static PALSHIP palship[PAL_MAX] = {0};
  PALSHIP *pp;

  /* itoc.020901:  palship iOAn@ I/O F */
  if (!palship[0].userno)	/* initialize *palship[] */
  {
    int fd;
    char fpath[64];
    PAL *pal;

    /* DĲvACWȰ@AGYܪBͱԭzAnsW~ͮ */
    usr_fpath(fpath, cuser.userid, fn_pal);
    if ((fd = open(fpath, O_RDONLY)) >= 0)
    {
      pp = palship;
      mgets(-1);
      while (pal = mread(fd, sizeof(PAL)))
      {
	if (pal->ship[0])	/* ͽˤ~J palship[] */
	{
	  pp->userno = pal->userno;
	  str_ncpy(pp->ship, pal->ship, sizeof(pp->ship));
	  pp++;
	}
      }
      close(fd);
    }    
  }

  if (ftype & (FTYPE_BOTHGOOD | FTYPE_MYGOOD | FTYPE_MYBAD))	/* ]n͡Bڪn͡BaH~ͽ˱ԭz */
  {
    /* g pal_sync H᪺BͦWO ID ƧǪAҼ{O_ binary search? */
    pp = palship;
    while (pp->userno)
    {
      if (pp->userno == userno)
	return pp->ship;
      pp++;
    }
  }
  return "";
}
#endif


static void
ulist_item(num, up, slot, now, sysop)
  int num;
  UTMP *up;
  int slot;
  time_t now;
  int sysop;
{
  time_t diff, ftype;
  int userno, ufo;
  char pager, buf[15], *fcolor;

  if (!(userno = up->userno))
  {
    outs("      < ͥ} >\n");
    return;
  }

  /* itoc.011022: YͤѤWAɥ idle өجP */
  if (up->status & STATUS_BIRTHDAY)
  {
    strcpy(buf, "\033[1;31mجP\033[m");
  }
  else
  {
#ifdef DETAIL_IDLETIME
    if ((diff = now - up->idle_time) >= 60)	/* WL 60 ~ⶢm */
      sprintf(buf, "%3d'%02d", diff / 60, diff % 60);
#else
    if (diff = up->idle_time)
      sprintf(buf, "%2d", diff);
#endif
    else
      buf[0] = '\0';
  }

  ufo = up->ufo;

  /*         pager A                       */
  /*  #GHIsA]Hs */
  /*  *GunͩIsABunͼs     */
  /*  !GunͩIsAHs   */
  /*  -GHIsAHs   */
  /*   GSNOS                 */
  if (ufo & UFO_QUIET)
  {
    pager = '#';
  }
  else if (ufo & UFO_PAGER)
  {
#ifdef HAVE_NOBROAD
    if (ufo & UFO_RCVER)
      pager = '!';
    else
#endif
      pager = '*';
  }
#ifdef HAVE_NOBROAD
  else if (ufo & UFO_RCVER)
  {
    pager = '-';
  }
#endif
  else
  {
    pager = ' ';
  }

  ftype = ulist_ftype[slot];

  fcolor = 
#ifdef HAVE_BRDMATE
# ifdef HAVE_ANONYMOUS
    up->mode == M_READA && !(currbattr & BRD_ANONYMOUS) && !strcmp(currboard, up->reading) ? COLOR_BRDMATE :
# else
    up->mode == M_READA && !strcmp(currboard, up->reading) ? COLOR_BRDMATE :
#  endif
#endif
    ftype & FTYPE_NORMAL ? COLOR_NORMAL : 
    ftype & FTYPE_BOTHGOOD ? COLOR_BOTHGOOD : 
    ftype & FTYPE_MYGOOD ? COLOR_MYGOOD : 
    ftype & FTYPE_OGOOD ? COLOR_OGOOD : 
    ftype & FTYPE_SELF ? COLOR_SELF : 
    ftype & FTYPE_MYBAD ? COLOR_MYBAD : 
    "";

  prints("%6d%c%c%s%-13s%-*.*s\033[m%-*.*s%-11.10s%s\n",
    num, ufo & UFO_CLOAK ? ')' : ' ', pager, 
    fcolor, up->userid, 
    (d_cols >> 1) + 21, (d_cols >> 1) + 20, up->username, 
    d_cols - (d_cols >> 1) + 19, d_cols - (d_cols >> 1) + 18, 
    pickup_ship ? pal_ship(ftype, up->userno) : 
#ifdef GUEST_WHERE
    (pager == ' ' || sysop || ftype & (FTYPE_SELF | FTYPE_BOTHGOOD | FTYPE_OGOOD) || !up->userlevel) ? 	/* iݨ guest Gm */
#else
    (pager == ' ' || sysop || ftype & (FTYPE_SELF | FTYPE_BOTHGOOD | FTYPE_OGOOD)) ?			/* ]ڬnͥiݨӷ */
#endif
    up->from : "*", bmode(up, 0), buf);
}


static int
ulist_body(xo)
  XO *xo;
{
  pickup *pp;
  UTMP *up;
  int num, max, tail, sysop, seecloak, slot;
#ifdef HAVE_SUPERCLOAK
  int seesupercloak;
#endif
#ifdef DETAIL_IDLETIME
  time_t now;
#endif

  max = xo->max;
  if (max <= 0)
  {
    if (vans("ثeSnͤWAnݬݨLϥΪ̶(Y/N)H[Y] ") != 'n')
    {
      cuser.ufo ^= UFO_PAL;
      cutmp->ufo = cuser.ufo;
      return ulist_init(xo);
    }
    return XO_QUIT;
  }

  num = xo->top;
  pp = &ulist_pool[num];
  tail = num + XO_TALL;
  if (max > tail)
    max = tail;

  sysop = HAS_PERM(PERM_ALLACCT);
  seecloak = HAS_PERM(PERM_SEECLOAK);
#ifdef HAVE_SUPERCLOAK
  seesupercloak = cuser.ufo & UFO_SUPERCLOAK;
#endif
#ifdef DETAIL_IDLETIME
  time(&now);
#endif

  move(3, 0);
  do
  {
    up = *pp;
    slot = up - ushm->uslot;

    /* itoc.011124: pGb ulist_body() o{ userno XAܤWoWb¤FAjs */
    if (ulist_userno[slot] != up->userno)
      return ulist_init(xo);

#ifdef DETAIL_IDLETIME
    ulist_item(++num, up, slot, now, sysop);
#else
    ulist_item(++num, up, slot, NULL, sysop);
#endif

    pp++;
  } while (num < max);
  clrtobot();

  /* return XO_NONE; */
  return XO_FOOT;	/* itoc.010403:  b_lines W feeter */
}


static int
ulist_cmp_userid(i, j)
  UTMP **i, **j;
{
  int k = ulist_ftype[(*i) - ushm->uslot] - ulist_ftype[(*j) - ushm->uslot];
  return k ? k : str_cmp((*i)->userid, (*j)->userid);
}


static int
ulist_cmp_host(i, j)
  UTMP **i, **j;
{
  int k = ulist_ftype[(*i) - ushm->uslot] - ulist_ftype[(*j) - ushm->uslot];
  /* return k ? k : (*i)->in_addr - (*j)->in_addr; */
  /* Kyo.050112: in_addr O unsigned int (u_long)A|y int ~P */
  return k ? k : (*i)->in_addr > (*j)->in_addr ? 1 : (*i)->in_addr < (*j)->in_addr ? -1 : 0;
}


static int
ulist_cmp_mode(i, j)
  UTMP **i, **j;
{
  int k = ulist_ftype[(*i) - ushm->uslot] - ulist_ftype[(*j) - ushm->uslot];
  return k ? k : (*i)->mode - (*j)->mode;
}


#ifdef HAVE_BRDMATE
static int
ulist_cmp_brdmate(i, j)
  UTMP **i, **j;
{
#ifdef HAVE_ANONYMOUS
  if (!(currbattr & BRD_ANONYMOUS) || HAS_PERM(PERM_SYSOP))	/* \ŪΦWOhCJ */
#endif
  {
    int ibrdmate = (*i)->mode == M_READA && !strcmp(currboard, (*i)->reading);
    int jbrdmate = (*j)->mode == M_READA && !strcmp(currboard, (*j)->reading);

    /* Ou */
    if (ibrdmate && !jbrdmate)
      return -1;
    if (jbrdmate && !ibrdmate)
      return 1;
  }

  /* OγOO񪺸ܡA ID Ƨ */
  return ulist_cmp_userid(i, j);
}
#endif


#ifdef HAVE_BRDMATE
#define PICKUP_WAYS	4
#else
#define PICKUP_WAYS	3
#endif

static int pickup_way = 0;	/* w]ƦC覡 0:N 1:Gm 2:ʺA 3:O */


static int (*ulist_cmp[PICKUP_WAYS]) () =
{
  ulist_cmp_userid,
  ulist_cmp_host,
  ulist_cmp_mode,
#ifdef HAVE_BRDMATE
  ulist_cmp_brdmate,
#endif
};


static char *msg_pickup_way[PICKUP_WAYS] =
{
  "ͥN",
  "ȳ~Gm",
  "ͰʺA",
#ifdef HAVE_BRDMATE
  "ON",
#endif
};


static int
ulist_paltype(up)		/* Bͺ */
  UTMP *up;
{
  const int userno = up->userno;

  if (userno == cuser.userno)
    return FTYPE_SELF;
  if (is_mybad(userno))
    return FTYPE_MYBAD;
  if (is_mygood(userno))
    return is_ogood(up) ? FTYPE_BOTHGOOD : FTYPE_MYGOOD;
  return is_ogood(up) ? FTYPE_OGOOD : FTYPE_NORMAL;
}


#if 0	/* itoc.041001: ulist_init()  */

  1. ushm->uslot O UTMP (ϥΪ̦W)AoOҦH@Ϊ

  2. CӤHWAUHUTG
     ulist_pool O ushm->uslot ޡAOۧڥiHݨǤH
     ulist_userno[i] O ushm->uslot[i] olF
     ulist_ftype[i] O ushm->uslot[i] olOڪ n/aH/@H

  3. b ulist_init() ̭h ushm->uslot sҦlAҼ{ ushm->uslot[i]
     pGڥiHݨoӤHAN⥦۶i ulist_pool
     Y ushm->uslot[i].userno != ulist_userno[i]AܳoӦlF@ӷsWHA
     ڴNhdLOOڪn/aHAðOb ulist_ftype[i]F
     Y ushm->uslot[i].userno == ulist_userno[i]AܳoӦlSHA
     ڴN ulist_ftype[i] ӷ@Bͺ

  4. F ulist_pool[] HAA ulist_pool[] ̧ڷQn覡ƧǡA
     b ulist_item() LXӪChOѷ ulist_ftype[]

  5. YHNڦbLBͦW椤ʡAL|ʧڪ cutmp->statusA
     ҥHˬd HAS_STATUS(STATUS_PALDIRTY)AڴNnڪ ulist_ftype[]

#endif


static int
ulist_init(xo)
  XO *xo;
{
  UTMP *up, *uceil;
  pickup *pp;
  int filter, slot, userno, paldirty;

  pp = ulist_pool;
  filter = cuser.ufo & UFO_PAL;
  if (paldirty = HAS_STATUS(STATUS_PALDIRTY))
    cutmp->status ^= STATUS_PALDIRTY;

  slot = 0;
  up = ushm->uslot;
  uceil = (void *) up + ushm->offset;

  mygood_num = ogood_num = 0;

  /* q ushm->uslot[] ۨ ulist_pool[] */
  do
  {
    userno = up->userno;

    if (userno > 0)
    {
      /* sWϥΪ̡AݬݥLO@B͡FSTATUS_PALDIRTY  ulist_ftype[] */
      if (ulist_userno[slot] != userno || paldirty)
      {
	ulist_userno[slot] = userno;
	ulist_ftype[slot] = ulist_paltype(up);
      }

      if (can_see(cutmp, up))
      {
	userno = ulist_ftype[slot];
	if (!filter || userno & (FTYPE_SELF | FTYPE_BOTHGOOD | FTYPE_MYGOOD))
	  *pp++ = up;

	/* ⦳XӦn */
	if (userno & (FTYPE_BOTHGOOD | FTYPE_MYGOOD))
	  mygood_num++;
	if (userno & (FTYPE_BOTHGOOD | FTYPE_OGOOD))
	  ogood_num++;
      }
    }
    slot++;
  } while (++up <= uceil);

  xo->max = slot = pp - ulist_pool;

  if (xo->pos >= slot)
    xo->pos = xo->top = 0;

  if (slot > 1)
    qsort(ulist_pool, slot, sizeof(pickup), ulist_cmp[pickup_way]);

  /* itoc.010928: ѩ ushm->count `AҥH total_user ӮեA
     WɴNҩl total_user  ushm->countAYϥΪ̨SӨϥΪ̦WANs total_user */
  if (!filter)
    total_user = slot;

  return ulist_head(xo);
}


static int
ulist_neck(xo)
  XO *xo;
{
  move(1, 0);

  prints("  ƦC覡G[\033[1m%s/%s\033[m] WHơG%d "
    COLOR_MYGOOD " ڪn͡G%d " COLOR_OGOOD " Pڬ͡G%d\033[m", 
    msg_pickup_way[pickup_way], 
    cuser.ufo & UFO_PAL ? "n" : "", 
    total_user, mygood_num, ogood_num);

  prints(NECKER_ULIST, d_cols >> 1, "", d_cols - (d_cols >> 1) + 4, pickup_ship ? "ͽ" : "Gm");
  return ulist_body(xo);
}


static int
ulist_head(xo)
  XO *xo;
{
  vs_head("ͦC", str_site);
  return ulist_neck(xo);
}


static int
ulist_toggle(xo)
  XO *xo;
{
  int ans, max;

#ifdef HAVE_BRDMATE
  ans = vans("ƦC覡 [1]N [2]ӷ [3]ʺA [4]O ") - '1';
#else
  ans = vans("ƦC覡 [1]N [2]ӷ [3]ʺA ") - '1';
#endif
  if (ans >= 0 && ans < PICKUP_WAYS && ans != pickup_way)	/* Thor.980705: from 0 .. PICKUP_WAYS-1 */
  {
    pickup_way = ans;
    max = xo->max;

    if (max > 1)
    {
      qsort(ulist_pool, max, sizeof(pickup), ulist_cmp[pickup_way]);
      return ulist_neck(xo);
    }
  }

  return XO_FOOT;
}


static int
ulist_pal(xo)
  XO *xo;
{
  cuser.ufo ^= UFO_PAL;
  cutmp->ufo = cuser.ufo;
  return ulist_init(xo);
}


static int
ulist_search(xo, step)
  XO *xo;
  int step;
{
  int num, pos, max;
  pickup *pp;
  char buf[IDLEN + 1];

  if (vget(b_lines, 0, "пJNμʺ١G", buf, IDLEN + 1, DOECHO))
  {
    str_lowest(buf, buf);
    
    pos = num = xo->pos;
    max = xo->max;
    pp = ulist_pool;
    do
    {
      pos += step;
      if (pos < 0) /* Thor.990124: ] max 0 */
	 pos = max - 1;
      else if (pos >= max)
	pos = 0;

      if (str_str(pp[pos]->userid, buf) ||	/* lkchu.990127: 䳡 id nn :p */
	str_sub(pp[pos]->username, buf)) 	/* Thor.990124: iH  nickname */
      {
	outf(FEETER_ULIST);	/* itoc.010913:  b_lines W feeter */	
	return pos + XO_MOVE;
      }

    } while (pos != num);
  }

  return XO_FOOT;
}


static int
ulist_search_forward(xo)
  XO *xo;
{
  return ulist_search(xo, 1); /* step = +1 */
}


static int
ulist_search_backward(xo)
  XO *xo;
{
  return ulist_search(xo, -1); /* step = -1 */
}


static int
ulist_addpal(xo)
  XO *xo;
{
  if (cuser.userlevel)
  {
    UTMP *up;
    int userno;

    up = ulist_pool[xo->pos];
    userno = up->userno;
    if (userno > 0 && (userno != cuser.userno) &&	/* lkchu.981217: ۤviB */
      !is_mygood(userno) && !is_mybad(userno))		/* |CJBͦW */
    {
      PAL pal;
      char fpath[64];

      pal_edit(PALTYPE_PAL, &pal, DOECHO);
      pal.userno = userno;
      strcpy(pal.userid, up->userid);
      usr_fpath(fpath, cuser.userid, fn_pal);

      /* itoc.001222: ˬdBͭӼ */
      if (rec_num(fpath, sizeof(PAL)) < PAL_MAX)
      {
	rec_add(fpath, &pal, sizeof(PAL));
	pal_cache();				/* BͦWPB */
	utmp_admset(userno, STATUS_PALDIRTY);
	return ulist_init(xo);
      }
      else
      {
	vmsg("zBͦWӦhAе[z");
	return XO_FOOT;
      }
    }
  }
  return XO_NONE;
}


static int
cmppal(pal)
  PAL *pal;
{
  return pal->userno == currchrono;
}


static int
ulist_delpal(xo)
  XO *xo;
{
  if (cuser.userlevel)
  {
    UTMP *up;
    int userno;

    up = ulist_pool[xo->pos];
    userno = up->userno;
    if (userno > 0 && (is_mygood(userno) || is_mybad(userno)))	/* bBͦW椤 */
    {
      if (vans(msg_del_ny) == 'y')
      {
	char fpath[64];

	usr_fpath(fpath, cuser.userid, fn_pal);

	currchrono = userno;
	if (!rec_del(fpath, sizeof(PAL), 0, cmppal))
	{
	  pal_cache();				/* BͦWPB */
	  utmp_admset(userno, STATUS_PALDIRTY);
	  return ulist_init(xo);
	}
      }
      return XO_FOOT;
    }
  }
  return XO_NONE;
}


static int
ulist_mail(xo)
  XO *xo;
{
  char userid[IDLEN + 1];

  /* ƻs@WAHKbgH ushm ܰʤF */
  strcpy(userid, ulist_pool[xo->pos]->userid);

  if (!*userid)
  {
    vmsg(MSG_USR_LEFT);
    return XO_FOOT;
  }

  return my_send(userid);
}


static int
ulist_query(xo)
  XO *xo;
{
  move(1, 0);
  clrtobot();
  my_query(ulist_pool[xo->pos]->userid);
  return ulist_neck(xo);
}


static int
ulist_broadcast(xo)
  XO *xo;
{
  int num, sysop;
  pickup *pp;
  UTMP *up;
  BMW bmw;

  num = cuser.userlevel;
  sysop = num & PERM_ALLADMIN;
  if (!sysop && (!(num & PERM_PAGE) || !(cuser.ufo & UFO_PAL)))
    return XO_NONE;

  num = xo->max;
  if (num <= 1)		/* pGuۤvAs */
    return XO_NONE;

  /* itoc.030101: pGΪOnͼsAP@ ID s */
  sysop = sysop && !(cuser.ufo & UFO_PAL);

  bmw.caller = NULL;
  bmw_edit(NULL, "sG", &bmw);

  if (bmw.caller)	/* bmw_edit() ^ Yes neXs */
  {
    /* itoc.000213: [ "> " FP@yϤ */
    sprintf(bmw.userid, "%s> ", cuser.userid);

    pp = ulist_pool;
    while (--num >= 0)
    {
      up = pp[num];

      if (!sysop)
      {
#ifdef HAVE_NOBROAD
	if (up->ufo & UFO_RCVER)
	  continue;
#endif

	/* itoc.011126: Y up-> wUAQL user ҨNɡA
	   |s~ӪDAosˬdO_ڪn */
	if (!is_mygood(up->userno))
	  continue;
      }

      if (can_override(up))
      {
	bmw.recver = up->userno;
	bmw_send(up, &bmw);
      }
    }
  }

  return XO_NONE;
}


static int
ulist_talk(xo)
  XO *xo;
{
  if (HAS_PERM(PERM_PAGE))
  {
    UTMP *up;

    up = ulist_pool[xo->pos];
    if (can_override(up))
      return talk_page(up) ? ulist_head(xo) : XO_FOOT;
  }
  return XO_NONE;
}


static int
ulist_write(xo)
  XO *xo;
{
  if (HAS_PERM(PERM_PAGE))
  {
    UTMP *up;

    if (up = ulist_pool[xo->pos])
      do_write(up);
  }
  return XO_NONE;
}


static int
ulist_edit(xo)			/* Thor: iuWdݤέקϥΪ */
  XO *xo;
{
  ACCT acct;

  if (!HAS_PERM(PERM_ALLACCT) || acct_load(&acct, ulist_pool[xo->pos]->userid) < 0)
    return XO_NONE;

  vs_bar("ϥΪ̳]w");
  acct_setup(&acct, 1);
  return ulist_head(xo);
}


static int
ulist_kick(xo)
  XO *xo;
{
  if (HAS_PERM(PERM_ALLACCT))
  {
    UTMP *up;
    pid_t pid;
    char buf[80];

    up = ulist_pool[xo->pos];
    if (pid = up->pid)
    {
      if (vans(msg_sure_ny) != 'y' || pid != up->pid)
	return XO_FOOT;

      sprintf(buf, "%s (%s)", up->userid, up->username);

      if ((kill(pid, SIGTERM) == -1) && (errno == ESRCH))
	utmp_free(up);
      else
	sleep(3);		/* Q𪺤HoɭԥbۧڤF_ */

      blog("KICK", buf);
      return ulist_init(xo);
    }
  }
  return XO_NONE;
}


#ifdef HAVE_CHANGE_NICK
static int
ulist_nickchange(xo)
  XO *xo;
{
  char *str, buf[UNLEN + 1];

  if (!cuser.userlevel)
    return XO_NONE;

  strcpy(buf, str = cutmp->username);
  if (vget(b_lines, 0, "пJsʺ١G", buf, UNLEN + 1, GCARRY))
  {  
    if (strcmp(buf, str))
    {
      strcpy(str, buf);
      strcpy(cuser.username, buf);	/* ʺ٤]@֧ cuser. */
      return ulist_body(xo);
    }
  }
  return XO_FOOT;
}
#endif


#ifdef HAVE_CHANGE_FROM
static int
ulist_fromchange(xo)
  XO *xo;
{
  char *str, buf[34];
  
  if (!cuser.userlevel)
    return XO_NONE;
  
  strcpy(buf, str = cutmp->from);
  if (vget(b_lines, 0, "пJsGmG", buf, sizeof(cutmp->from), GCARRY))
  {
    if (strcmp(buf, str))
    {
      strcpy(str, buf);
      return ulist_body(xo);
    }
  }

  return XO_FOOT;
}
#endif


#ifdef HAVE_CHANGE_ID
static int
ulist_idchange(xo)
  XO *xo;
{
  char *str, buf[IDLEN + 1];

  /* itoc.010717.: o\ണѯiHbϥΪ̦WȮɧۤv IDA
     Oѩ ulist jO userno ӧP_AҥHunݦӤw */
  
  if (!HAS_PERM(PERM_ALLADMIN))
    return XO_NONE;
  
  strcpy(buf, str = cutmp->userid);
  if (vget(b_lines, 0, "пJsעҡG", buf, IDLEN + 1, GCARRY))
  {
    if (strcmp(buf, str))
    {
      strcpy(str, buf);
      return ulist_body(xo);
    }
  }

  return XO_FOOT;
}
#endif


static int  
ulist_cloak(xo)			/* itoc.010908: ֳt */
  XO *xo;
{
  if (HAS_PERM(PERM_CLOAK))
  {
    cuser.ufo ^= UFO_CLOAK;
    cutmp->ufo = cuser.ufo;
    return ulist_init(xo);
  }
  return XO_NONE;
}


#ifdef HAVE_SUPERCLOAK
static int
ulist_supercloak(xo)		/* itoc.010908: ֳt */
  XO *xo;
{
  if (cuser.ufo & UFO_SUPERCLOAK)	/* Av */
  {
    cuser.ufo &= ~(UFO_CLOAK | UFO_SUPERCLOAK);
    cutmp->ufo = cuser.ufo;
    return ulist_init(xo);
  }
  else if (HAS_PERM(PERM_ALLADMIN))	/* iJ */
  {
    cuser.ufo |= (UFO_CLOAK | UFO_SUPERCLOAK);
    cutmp->ufo = cuser.ufo;
    return ulist_init(xo);
  }
  return XO_NONE;
}
#endif


static int
ulist_ship(xo)
  XO *xo;
{
  pickup_ship = ~pickup_ship;
  return ulist_neck(xo);
}


static int
ulist_recall(xo)
  XO *xo;
{
  if (cuser.userlevel)
  {
    t_bmw();
    return ulist_head(xo);
  }
  return XO_NONE;
}


static int
ulist_display(xo)
  XO *xo;
{
  if (cuser.userlevel)
  {
    t_display();
    return ulist_head(xo);
  }
  return XO_NONE;
}


static int
ulist_help(xo)
  XO *xo;
{
  xo_help("ulist");
  return ulist_head(xo);
}


static KeyFunc ulist_cb[] =
{
  XO_INIT, ulist_init,
  XO_LOAD, ulist_body,
  XO_HEAD, ulist_head,
  /* XO_BODY, ulist_body, */	/* SΨ */

  'f', ulist_pal,
  'y', ulist_pal,		/* itoc.010205: H| yank NΦbo */
  'a', ulist_addpal,
  'd', ulist_delpal,
  't', ulist_talk,
  'w', ulist_write,
  'l', ulist_recall,		/* y^U */
  'L', ulist_display,
  'r', ulist_query,
  'q', ulist_query,		/* itoc.020109: ϥΪ̲ߺD q d */
  'B', ulist_broadcast,
  's', ulist_init,		/* refresh status Thor: usernD */
  'S', ulist_ship,

  Ctrl('K'), ulist_kick,
  Ctrl('O'), ulist_edit,
  Ctrl('Q'), ulist_query,

#ifdef HAVE_CHANGE_NICK
  Ctrl('N'), ulist_nickchange,
#endif
#ifdef HAVE_CHANGE_FROM
  Ctrl('F'), ulist_fromchange,
#endif
#ifdef HAVE_CHANGE_ID
  Ctrl('D'), ulist_idchange,
#endif

#if 0
  '/', ulist_search,
#endif
  /* Thor.990125: iejM, id or nickname */
  '/', ulist_search_forward,
  '?', ulist_search_backward,

  'm', ulist_mail,
  KEY_TAB, ulist_toggle,

  'i', ulist_cloak,
#ifdef HAVE_SUPERCLOAK
  'H', ulist_supercloak,
#endif

  'h', ulist_help
};


void
talk_main()
{
  char fpath[64];

  xz[XZ_ULIST - XO_ZONE].xo = &ulist_xo;
  xz[XZ_ULIST - XO_ZONE].cb = ulist_cb;

  /* itoc.010715: ѩ erevy_Z iHiJ bmwAҥH@WNnJ */
  usr_fpath(fpath, cuser.userid, fn_bmw);
  xz[XZ_BMW - XO_ZONE].xo = xo_new(fpath);
}
