/*-------------------------------------------------------*/
/* more.c	( NTHU CS MapleBBS Ver 3.00 )		 */
/*-------------------------------------------------------*/
/* target : simple & beautiful ANSI/Chinese browser	 */
/* create : 95/03/29				 	 */
/* update : 97/03/29				 	 */
/*-------------------------------------------------------*/


#include "bbs.h"


/* ----------------------------------------------------- */
/* buffered file read					 */
/* ----------------------------------------------------- */


#define MORE_BUFSIZE	4096


static int more_width;	/* more screen e */

static uschar more_pool[MORE_BUFSIZE];
static int more_base;		/* more_pool[more_base ~ more_base+more_size]  */
static int more_size;


/* ----------------------------------------------------- */
/* mget \ŪrɡFmread \ŪGi			 */
/* ----------------------------------------------------- */


/* itoc.041226.: mgets() M more_line() @˪
   1. mgets  more_pool ŶFmore_line hO|ȼgJ@ buffer
   2. mgets |۰_Fmore_line hO|۰_b more_width
   ҥH mgets OΦb@ǨtɳBzάO edit.cA more_line uΦb more()
 */


char *
mgets(fd)
  int fd;
{
  char *pool, *base, *head, *tail;
  int ch;

  if (fd < 0)
  {
    more_base = more_size = 0;
    return NULL;
  }

  pool = more_pool;
  base = pool + more_base;
  tail = pool + more_size;
  head = base;

  for (;;)
  {
    if (head >= tail)
    {
      if (ch = head - base)
	memcpy(pool, base, ch);

      head = pool + ch;
      ch = read(fd, head, MORE_BUFSIZE - ch);

      if (ch <= 0)
	return NULL;

      base = pool;
      tail = head + ch;
      more_size = tail - pool;
    }

    ch = *head;

    if (ch == '\n')
    {
      *head++ = '\0';
      more_base = head - pool;
      return base;
    }

    head++;
  }
}


/* use mgets(-1) to reset */


void *
mread(fd, len)
  int fd, len;
{
  char *pool;
  int base, size;

  base = more_base;
  size = more_size;
  pool = more_pool;

  if (size < len)
  {
    if (size)
      memcpy(pool, pool + base, size);

    base = read(fd, pool + size, MORE_BUFSIZE - size);

    if (base <= 0)
      return NULL;

    size += base;
    base = 0;
  }

  more_base = base + len;
  more_size = size - len;

  return pool + base;
}


/* ----------------------------------------------------- */
/* more \Ūr					 */
/* ----------------------------------------------------- */


#define	STR_ANSICODE	"[0123456789;"


static uschar *fimage;		/* file image begin */
static uschar *fend;		/* file image end */
static uschar *foff;		/* ثeŪ */


static int
more_line(buf)
  char *buf;
{
  int ch, len, bytes, in_ansi, in_chi;

  len = bytes = in_ansi = in_chi = 0;

  for (;;)
  {
    if (foff >= fend)
      break;

    ch = *foff;

    /* weiyu.040802: pGoXOrXAOuѤU@XŶiHLA򤣭nLoX */
    if (in_chi || IS_ZHC_HI(ch))
      in_chi ^= 1;
    if (in_chi && (len >= more_width - 1 || bytes >= ANSILINELEN - 2))
      break;

    foff++;
    bytes++;

    if (ch == '\n')
      break;

    if (ch == KEY_ESC)
    {
      in_ansi = 1;
    }
    else if (in_ansi)
    {
      if (!strchr(STR_ANSICODE, ch))
	in_ansi = 0;
    }
    else if (isprint2(ch))
    {
      len++;
    }
    else
    {
      ch = ' ';		/* LXӪť */
      len++;
    }

    *buf++ = ch;

    /* YtXפwF more_width rAΧtXפwF ANSILINELEN-1A}j */
    if (len >= more_width || bytes >= ANSILINELEN - 1)
    {
      /* itoc.031123: pGOXAYϤtXפwF more_width FA٥iH~Y */
      if ((in_ansi || (foff < fend && *foff == KEY_ESC)) && bytes < ANSILINELEN - 1)
	continue;

      /* itoc.031123: AˬdU@ӦrOO '\n'AקKnO more_width  ANSILINELEN-1 ɡA|h@Cť */
      if (foff < fend && *foff == '\n')
      {
	foff++;
	bytes++;
      }
      break;
    }
  }

  *buf = '\0';

  return bytes;
}


static void
outs_line(str)			/* LX@뤺e */
  char *str;
{
  int ch1, ch2, ansi;

  /* BzޥΪ & ި */

  ch1 = str[0];
  ch2 = str[1];

  if (ch2 == ' ' && (ch1 == QUOTE_CHAR1 || ch1 == QUOTE_CHAR2))	/* ި */
  {
    ansi = 1;
    ch1 = str[2];
    outs((ch1 == QUOTE_CHAR1 || ch1 == QUOTE_CHAR2) ? "\033[33m" : "\033[36m");	/* ޥΤ@h/GhPC */
  }
  else if (ch1 == '\241' && ch2 == '\260')	/*  ި */
  {
    ansi = 1;
    outs("\033[1;36m");
  }
  else
    ansi = 0;

  /* LXe */

  if (!hunt[0])
  {
    outx(str);
  }
  else
  {
    int len;
    char buf[ANSILINELEN];
    char *ptr1, *ptr2;

    len = strlen(hunt);
    ptr2 = buf;
    while (1)
    {
      if (!(ptr1 = str_sub(str, hunt)))
      {
	str_ncpy(ptr2, str, buf + ANSILINELEN - ptr2 - 1);
	break;
      }

      if (buf + ANSILINELEN - 1 <= ptr2 + (ptr1 - str) + (len + 7))	/* buf Ŷ */
	break;

      str_ncpy(ptr2, str, ptr1 - str + 1);
      ptr2 += ptr1 - str;
      sprintf(ptr2, "\033[7m%.*s\033[m", len, ptr1);
      ptr2 += len + 7;
      str = ptr1 + len;
    }

    outx(buf);
  }

  if (ansi)
    outs(str_ransi);
}


static void
outs_header(str, header_len)	/* LXY */
  char *str;
  int header_len;
{
  static char header1[LINE_HEADER][LEN_AUTHOR1] = {"@",   "D",   "ɶ"};
  static char header2[LINE_HEADER][LEN_AUTHOR2] = {"oHH", "  D", "oH"};
  int i;
  char *ptr, *word;

  /* BzY */

  if ((header_len == LEN_AUTHOR1 && !memcmp(str, header1[0], LEN_AUTHOR1 - 1)) ||
    (header_len == LEN_AUTHOR2 && !memcmp(str, header2[0], LEN_AUTHOR2 - 1)))
  {
    /* @/ݪO YGASOBz */
    word = str + header_len;
    if ((ptr = strstr(word, str_post1)) || (ptr = strstr(word, str_post2)))
    {
      ptr[-1] = ptr[4] = '\0';
      prints(COLOR5 " %s " COLOR6 "%-*.*s" COLOR5 " %s " COLOR6 "%-13s\033[m", 
	header1[0], d_cols + 53, d_cols + 53, word, ptr, ptr + 5);
    }
    else
    {
      /* ֬ݪOo */
      prints(COLOR5 " %s " COLOR6 "%-*.*s\033[m", 
	header1[0], d_cols + 72, d_cols + 72, word);
    }
    return;
  }

  for (i = 1; i < LINE_HEADER; i++)
  {
    if ((header_len == LEN_AUTHOR1 && !memcmp(str, header1[i], LEN_AUTHOR1 - 1)) ||
      (header_len == LEN_AUTHOR2 && !memcmp(str, header2[i], LEN_AUTHOR2 - 1)))
    {
      /* LYu@ */
      word = str + header_len;
      prints(COLOR5 " %s " COLOR6 "%-*.*s\033[m", 
	header1[i], d_cols + 72, d_cols + 72, word);
      return;
    }
  }

  /* pGOYAN@rLX */
  outs_line(str);
}


static inline void
outs_footer(buf, lino, fsize)
  char *buf;
  int lino;
  int fsize;
{
  int i;

  /* P.1  (PAGE_SCROLL + 1) CAL Page O PAGE_SCROLL C */

  /* prints(FOOTER_MORE, (lino - 2) / PAGE_SCROLL + 1, ((foff - fimage) * 100) / fsize); */

  /* itoc.010821: FM FOOTER  */
  sprintf(buf, FOOTER_MORE, (lino - 2) / PAGE_SCROLL + 1, ((foff - fimage) * 100) / fsize);
  outs(buf);

  for (i = b_cols + sizeof(COLOR1) + sizeof(COLOR2) - strlen(buf); i > 3; i--)
  {
    /* 񺡳̫᪺ťCA̫d@Ӫť */
    outc(' ');
  }
  outs(str_ransi);
}


#ifdef SLIDE_SHOW
static int slideshow;		/* !=0:  movie t */

static int
more_slideshow()
{
  int ch;

  if (!slideshow)
  {
    ch = vkey();

    if (ch == '@')
    {
      slideshow = vans("пܩMt 1(̺C)9(̧)H񤤫NiG") - '0';
      if (slideshow < 1 || slideshow > 9)
	slideshow = 5;

      ch = KEY_PGDN;
    }
  }  
  else
  {
    struct timeval tv[9] =
    {
      {4, 0}, {3, 0}, {2, 0}, {1, 500000}, {1, 0},
      {0, 800000}, {0, 600000}, {0, 400000}, {0, 200000}
    };

    refresh();
    ch = 1;
    if (select(1, (fd_set *) &ch, NULL, NULL, tv + slideshow - 1) > 0)
    {
      /* Y񤤫NAh */
      slideshow = 0;
      ch = vkey();
    }
    else
    {
      ch = KEY_PGDN;
    }
  }

  return ch;
}
#endif


#define END_MASK	0x200	/*  KEY_END F̫@ */

#define HUNT_MASK	0x400
#define HUNT_NEXT	0x001	/*  n jMU@ */
#define HUNT_FOUND	0x002	/*  / }ljMABwg match r */
#define HUNT_START	0x004	/*  / }ljMAB| match r */

#define MAXBLOCK	256	/* OX block  offsetCi[t MAXBLOCK*32 CHbW/½ɪt */

/* Thor.990204: Ǧ^ -1 LkshowX
                        0 show
                       >0 showA_ҫkey */
int
more(fpath, footer)
  char *fpath;
  char *footer;
{
  char buf[ANSILINELEN];
  int i;

  uschar *headend;		/* Y */

  int shift;			/* ٻݭnUʴXC */
  int lino;			/* ثe line number */
  int header_len;		/* YסAPɤ]O/~HϧO */
  int key;			/*  */
  int cmd;			/* _ɩҫ */

  int fsize;			/* ɮפjp */
  static off_t block[MAXBLOCK];	/* C 32 C@ blockAO block  offset */

  if (!(fimage = f_img(fpath, &fsize)))
    return -1;

  foff = fimage;
  fend = fimage + fsize;

  /* more_width = b_cols - 1; */	/* itoc.070517.: YγoӡACC̤jrƷ|M header  footer  (Y|dդG) */
  more_width = b_cols + 1;		/* itoc.070517.: YγoӡACC̤jrƻPùPe */

  /* Ya */
  for (i = 0; i < LINE_HEADER; i++)
  {
    if (!more_line(buf))
      break;

    /* ŪXɮײĤ@CAӧP_H٬O~H */
    if (i == 0)
    {
      header_len = 
        !memcmp(buf, str_author1, LEN_AUTHOR1) ? LEN_AUTHOR1 :	/* u@:v峹 */
        !memcmp(buf, str_author2, LEN_AUTHOR2) ? LEN_AUTHOR2 : 	/* uoHH:vH峹 */
        0;							/* SY */
    }

    if (!*buf)	/* Ĥ@ "\n\n" OY */
      break;
  }
  headend = foff;

  /* ks */
  foff = fimage;

  lino = cmd = 0;
  block[0] = 0;

#ifdef SLIDE_SHOW
  slideshow = 0;
#endif

  if (hunt[0])		/* b xxxx_browse() ШDjMr */
  {
    str_lowest(hunt, hunt);
    shift = HUNT_MASK | HUNT_START;
  }
  else
  {
    shift = b_lines;
  }

  clear();

  while (more_line(buf))
  {
    /* ------------------------------------------------- */
    /* LX@Cr					 */
    /* ------------------------------------------------- */

    /* eXC~ݭnBzY */
    if (foff <= headend)
      outs_header(buf, header_len);
    else
      outs_line(buf);

    outc('\n');

    /* ------------------------------------------------- */
    /*  shift ӨMwʧ@				 */
    /* ------------------------------------------------- */

    /* itoc.030303.: shift bNq
       >0: ٻݭnUXC
       <0: ٻݭnWXC
       =0: oAݨϥΪ̫ */

    if (shift > 0)		/* ٭nU shift C */
    {
      if (lino >= b_lines)	/* ubi moreAĤ@LĤ@ɤ~i lino <= b_lines */
	scroll();

      lino++;

      if ((lino % 32 == 0) && ((i = lino >> 5) < MAXBLOCK))
	block[i] = foff - fimage;


      if (!(shift & (HUNT_MASK | END_MASK)))	/* @Ū */
      {
	shift--;
      }
      else if (shift & HUNT_MASK)		/* rjM */
      {
	if (shift & HUNT_NEXT)	/*  n jMU@ */
	{
	  /* @NӦC */
	  if (str_sub(buf, hunt))
	    shift = 0;
	}
	else			/*  / }ljM */
	{
	  /* YbĤGHA@NӦCF
	     YbĤ@AŪĤ@~ఱ */
	  if (shift & HUNT_START && str_sub(buf, hunt))
	    shift ^= HUNT_START | HUNT_FOUND;		/*  HUNT_START å[W HUNT_FOUND */
	  if (shift & HUNT_FOUND && lino >= b_lines)
	    shift = 0;
	}
      }
    }
    else if (shift < 0)		/* ٭nW -shift C */
    {
      shift++;

      if (!shift)
      {
	move(b_lines, 0);
	clrtoeol();

	/* ѤU b_lines+shift CO rscrollAoffsect hTmFo̪ i O`@n shift C */
	for (i += b_lines; i > 0; i--)
	  more_line(buf);
      }
    }

    if (foff >= fend)		/* wgŪɮ */
    {
      /* խYO End ̫@A򰱯db 100% ӤF_h@ߵ */
      if (!(shift & END_MASK))
	break;
      shift = 0;
    }

    if (shift)			/* ٻݭn~Ū */
      continue;

    /* ------------------------------------------------- */
    /* 즹Lһݪ shift CAUӦLX footer õ */
    /* ϥΪ̫					 */
    /* ------------------------------------------------- */

re_key:

    outs_footer(buf, lino, fsize);

#ifdef SLIDE_SHOW
    key = more_slideshow();
#else
    key = vkey();
#endif

    if (key == ' ' || key == KEY_PGDN || key == KEY_RIGHT || key == Ctrl('F'))
    {
      shift = PAGE_SCROLL;
    }

    else if (key == KEY_DOWN || key == '\n')
    {
      shift = 1;
    }

    else if (key == KEY_PGUP || key == Ctrl('B') || key == KEY_DEL)
    {
      /* itoc.010324: F̶}lAW}Aæ^ 'k' (keymap[] wqW@g) */
      if (lino <= b_lines)
      {
	cmd = 'k';
	break;
      }
      /* ̦huW@}l */
      i = b_lines - lino;
      shift = BMAX(-PAGE_SCROLL, i);
    }

    else if (key == KEY_UP)
    {
      /* itoc.010324: F̶}lAW}Aæ^ 'k' (keymap[] wqW@g) */
      if (lino <= b_lines)
      {
	cmd = 'k';
	break;
      }
      shift = -1;
    }

    else if (key == KEY_END || key == '$')
    {
      shift = END_MASK;
    }

    else if (key == KEY_HOME || key == '0')
    {
      if (lino <= b_lines)	/* wgb̶}lF */
	shift = 0;
      else
	shift = -PAGE_SCROLL - 1;
    }

    else if (key == '/' || key == 'n')
    {
      if (key == 'n' && hunt[0])	/* pG n oJLjMrAP / */
      {
	shift = HUNT_MASK | HUNT_NEXT;
      }
      else if (vget(b_lines, 0, "jMG", hunt, sizeof(hunt), DOECHO))
      {
	str_lowest(hunt, hunt);
	shift = HUNT_MASK | HUNT_START;
      }
      else				/* pGjMܡAø footer Yi */
      {
	shift = 0;
      }
    }

    else if (key == 'C')	/* Thor.980405: more ɥisJȦs */
    {
      FILE *fp;
      if (fp = tbf_open())
      {
	f_suck(fp, fpath);
	fclose(fp);
      }
      shift = 0;		/* ø footer */
    }

    else if (key == 'h')
    {
      screenline slt[T_LINES];
      uschar *tmp_fimage;
      uschar *tmp_fend;
      uschar *tmp_foff;
      off_t tmp_block[MAXBLOCK];

      /* itoc.060420: xo_help() |iJĤG more()AҥHnҦ static ŧiOU */
      tmp_fimage = fimage;
      tmp_fend = fend;
      tmp_foff = foff;
      memcpy(tmp_block, block, sizeof(tmp_block));

      vs_save(slt);
      xo_help("post");
      vs_restore(slt);

      fimage = tmp_fimage;
      fend = tmp_fend;
      foff = tmp_foff;
      memcpy(block, tmp_block, sizeof(block));

      shift = 0;
    }

    else		/* L䳣OϥΪ̤_ */
    {
      /* itoc.041006: ϥΪ̤_n > 0 ( KEY_LEFT O < 0) */
      cmd = key > 0 ? key : 'q';
      break;
    }

    /* ------------------------------------------------- */
    /* ϥΪ̤wAY break h}jF_h̷ shift */
    /*  (Y䪺) ӰPʧ@		 */
    /* ------------------------------------------------- */

    if (shift > 0)			/* ǳƤU shift C */
    {
      if (shift < (HUNT_MASK | HUNT_START))	/* @U */
      {
	/* itoc.041114.: ؼЬOqX lino-b_lines+1+shift ~ lino+shift CeG
	   NunM footer YiALN浹e`ǦL shift C{ */

	move(b_lines, 0);
	clrtoeol();

#if 1
	/* itoc.041116: End @kM@UiHO@˪AOpGJW峹ɡA
	   |ye`ǦL shift C{No@½A̫@Ao˷|Ӧh outs_line() դuA
	   ҥHbSOˬdW峹ɡANh̫@Ҧb */

	if ((shift & END_MASK) && (fend - foff >= MORE_BUFSIZE))	/* ٦@SŪLA~SOBz */
	{
	  int totallino = lino;

	  /* Ū̫@CݬݥXC */
	  while (more_line(buf))
	  {
	    totallino++;
	    if ((totallino % 32 == 0) && ((i = totallino >> 5) < MAXBLOCK))
	      block[i] = foff - fimage;
	  }

	  /* 첾W@ block  */
	  i = (totallino - b_lines) >> 5;
	  if (i >= MAXBLOCK)
	    i = MAXBLOCK - 1;
	  foff = fimage + block[i];
	  i = i << 5;

	  /* AqW@ block ݦ첾 totallino-b_lines+1 C */
	  for (i = totallino - b_lines - i; i > 0; i--)
	    more_line(buf);

	  lino = totallino - b_lines;
	}
#endif
      }
      else
      {
	/* '/' qY}ljM */
	lino = 0;
	foff = fimage;
	clear();
      }
    }
    else if (shift < 0)			/* ǳƤW -shift C */
    {
      if (shift >= -PAGE_SCROLL)	/* WƦC */
      {
	lino += shift;

	/* itoc.041114.: ؼЬOqX lino-b_lines+1 ~ lino CeG
	  1. qY첾 lino-b_lines+1 C
	  2. 䤤 b_lines+shift COܪeA rscroll F
	  3. be outs_line() aLX -shift C
	  4. ̫A첾~ rscroll C
	*/

	/* 첾W@ block  */
	i = (lino - b_lines) >> 5;
	if (i >= MAXBLOCK)
	  i = MAXBLOCK - 1;
	foff = fimage + block[i];
	i = i << 5;

	/* AqW@ block ݦ첾 lino-b_lines+1 C */
	for (i = lino - b_lines - i; i > 0; i--)
	  more_line(buf);

	for (i = shift; i < 0; i++) 
	{
	  rscroll();
	  move(0, 0);
	  clrtoeol();
	}

	i = shift;
      }
      else			/* Home */
      {
	/* itoc.041226.: ؼЬOqX 1 ~ b_lines CeG
           @kNOksAqYAL b_lines CYi */

	clear();

	foff = fimage;
	lino = 0;
	shift = b_lines;
      }
    }
    else				/* ø footer  re-key */
    {
      move(b_lines, 0);
      clrtoeol();
      goto re_key;
    }
  }	/* while j骺 */

  /* --------------------------------------------------- */
  /* ɮפwgq (cmd = 0)  ϥΪ̤_ (cmd != 0)	 */
  /* --------------------------------------------------- */

  free(fimage);

  if (!cmd)	/* ɮץ`qAnBz footer */
  {
    if (footer)		/*  footer */
    {
      if (footer != (char *) -1)
	outf(footer);
      else
	outs(str_ransi);
    }
    else		/* S footer n vmsg() */
    {
      /* lkchu.981201: M@HK| */
      move(b_lines, 0);
      clrtoeol();

      if (vmsg(NULL) == 'C')	/* Thor.990204: SO`NY^ 'C' ܼȦs */
      {
	FILE *fp;

	if (fp = tbf_open()) 
	{
	  f_suck(fp, fpath); 
	  fclose(fp);
	}
      }
    }
  }
  else		/* ϥΪ̤_A} */
  {
    outs(str_ransi);
  }

  hunt[0] = '\0';

  /* Thor.990204: keyi^Ǧmore~ */
  return cmd;
}
