/* ----------------------------------------------------- */
/* hdr_stamp - create unique HDR based on timestamp	 */
/* ----------------------------------------------------- */
/* fpath - directory					 */
/* token - (A / F / 0) | [HDR_LINK / HDR_COPY]		 */
/* ----------------------------------------------------- */
/* return : open() fd (not close yet) or link() result	 */
/* ----------------------------------------------------- */


#include "dao.h"
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#if 0	/* itoc.030303.: ² */

  hdr_stamp() |X@ӷs HDRA̶ǤJ token PӦtG

   0 : sW@gH(family O @)A^Ǫ fpath O hdr ҫV
       M hdr_fpath(fpath, folder, hdr); Ҳͪ fpath ۦP

  'A': sW@g峹(family O A)A^Ǫ fpath O hdr ҫV
       M hdr_fpath(fpath, folder, hdr); Ҳͪ fpath ۦP

  'F': sW@Өv(family O F)A^Ǫ fpath O hdr ҫV
       M hdr_fpath(fpath, folder, hdr); Ҳͪ fpath ۦP

  HDR_LINK      : fpath wɮ׮ɡAnƻsɮרsH(family O @) h
                  ñN hdr VogsHA^Ǫ fpath Oɮ
                  ɮשMsHO hard linkAF䤤@gAt@g]|@_Q
                  RɮסAsHä|QR

  HDR_LINK | 'A': fpath wɮ׮ɡAnƻsɮרs峹(family O A) h
                  ñN hdr Vogs峹A^Ǫ fpath Oɮ
                  ɮשMs峹O hard linkAF䤤@gAt@g]|@_Q
                  RɮסAs峹ä|QR

  HDR_COPY      : fpath wɮ׮ɡAnƻsɮרsH(family O @) h
                  ñN hdr VogsHA^Ǫ fpath Oɮ
                  ɮשMsHO copyAF䤤@gAt@gä|Q
                  ɮ׻PsHOWߤGɮ

  HDR_COPY | 'A': fpath wɮ׮ɡAnƻsɮרs峹(family O A) h
                  ñN hdr Vogs峹A^Ǫ fpath Oɮ
                  ɮשMs峹O copyAF䤤@gAt@gä|Q
                  ɮ׻Ps峹OWߤGɮ

#endif

int
hdr_stamp(folder, token, hdr, fpath)
  char *folder;
  int token;
  HDR *hdr;
  char *fpath;
{
  char *fname, *family;
  int rc, chrono;
  char *flink, buf[128];

  flink = NULL;
  if (token & (HDR_LINK | HDR_COPY))
  {
    flink = fpath;
    fpath = buf;
  }

  fname = fpath;
  while (rc = *folder++)
  {
    *fname++ = rc;
    if (rc == '/')
      family = fname;
  }
  if (*family != '.')
  {
    fname = family;
    family -= 2;
  }
  else
  {
    fname = family + 1;
    *fname++ = '/';
  }

  if (rc = token & 0xdf)	/* ܤjg */
  {
    *fname++ = rc;
  }
  else
  {
    *fname = *family = '@';
    family = ++fname;
  }

  chrono = time(0);

  for (;;)
  {
    *family = radix32[chrono & 31];
    archiv32(chrono, fname);

    if (flink)
    {
      if (token & HDR_LINK)
	rc = f_ln(flink, fpath);
      else
        rc = f_cp(flink, fpath, O_EXCL);
    }
    else
    {
      rc = open(fpath, O_WRONLY | O_CREAT | O_EXCL, 0600);
    }

    if (rc >= 0)
    {
      memset(hdr, 0, sizeof(HDR));
      hdr->chrono = chrono;
      str_stamp(hdr->date, &hdr->chrono);
      strcpy(hdr->xname, --fname);
      break;
    }

    if (errno != EEXIST)
      break;

    chrono++;
  }

  return rc;
}
