/*-------------------------------------------------------*/
/* struct.h	( NTHU CS MapleBBS Ver 2.36 )		 */
/*-------------------------------------------------------*/
/* target : all definitions about data structure	 */
/* create : 95/03/29				 	 */
/* update : 95/12/15				 	 */
/*-------------------------------------------------------*/


#ifndef _STRUCT_H_
#define _STRUCT_H_


/* screen control */

#define STRLEN		80	/* Length of most string data */
#define ANSILINELEN	500	/* Maximum Screen width in charsAWL 1023 */

#define SCR_WIDTH	78	/* edit/talk/camera screen width */

#define TAB_STOP	4	/*  TAB Xť (nO 2 ) */
#define TAB_WIDTH	(TAB_STOP - 1)

#define T_LINES		50	/* maximum total lines */
#define T_COLS		120	/* maximum total columnsAn ANSILINELEN p */

/* board structure */

#define BNLEN		12	/* Length of board name */
#define BCLEN		4	/* Length of board class */
#define BTLEN		43	/* Length of board title */
#define BMLEN		36	/* Length of board managers */

/* file structure */

#define TTLEN		72	/* Length of title */
#define FNLEN		28	/* Length of filename  */

/* user structure */
/* DES sXkA 8 ӦrתrAͪȬ 13 줸 */

#define IDLEN		12	/* Length of user id */
#define PASSLEN		13	/* Length of encrypted passwd field */
#define PSWDLEN		8	/* Length of passwd ([K) */
#define RNLEN		19	/* Length of real name */
#define UNLEN		23	/* Length of user name */


typedef char const *STRING;
typedef unsigned char uschar;	/* length = 1 */
typedef unsigned int usint;	/* length = 4 */
typedef struct UTMP UTMP;


/* ----------------------------------------------------- */
/* ϥΪ̱b .ACCT struct : 512 bytes			 */
/* ----------------------------------------------------- */


typedef struct
{
  int userno;			/* unique positive code */

  char userid[IDLEN + 1];	/* ID */
  char passwd[PASSLEN + 1];	/* KX */
  char realname[RNLEN + 1];	/* umW */
  char username[UNLEN + 1];	/* ʺ */

  usint userlevel;		/* v */
  usint ufo;			/* habit */
  uschar signature;		/* w]ñW */

  char year;			/* ͤ(~) */
  char month;			/* ͤ() */
  char day;			/* ͤ() */
  char sex;			/* ʧO 0: _:k :k */
  int money;			/* ȹ */
  int gold;			/*  */

  int numlogins;		/* W */
  int numposts;			/* o */
  int numemails;		/* Ho Inetrnet E-mail  */

  time_t firstlogin;		/* Ĥ@Wɶ */
  time_t lastlogin;		/* W@Wɶ */
  time_t tcheck;		/* W check Hc/BͦW檺ɶ */
  time_t tvalid;		/* YvAvɶF
                                   YvBqL{ҡAqL{ҪɶF
                                   YvBqL{ҡA{Ҩ窺 time-seed */

  char lasthost[30];		/* WnJӷ */
  char email[60];		/* ثenOqlHc */
}      ACCT;


typedef struct			/* 16 bytes */
{
  time_t uptime;
  char userid[IDLEN];
}      SCHEMA;


#ifdef HAVE_REGISTER_FORM

/* itoc.041025: RFROM X{M ACCT @˦ȥiणP
   RFORM M ACCT ߤGۦPO usernoBuserid */

typedef struct	/* U (Register From) 256 bytes */
{
  int userno;
  time_t rtime;
  char userid[IDLEN + 1];
  char agent[IDLEN + 1];
  char nouse[20];
  char career[50];
  char address[60];
  char phone[20];
  char reply[72];
}      RFORM;

#endif


#include "hdr.h"


/* ----------------------------------------------------- */
/* control of board vote : 256 bytes			 */
/* ----------------------------------------------------- */


/* itoc.041101.: VCH M HDR  xname mB׭nǰt */

typedef struct VoteControlHeader
{
  time_t chrono;		/* 벼}ɶ */	/* Thor:  key ӥB match HDR chrono */
  time_t bstamp;		/* ݪOѥNX */	/* Thor:  key */
  time_t vclose;		/* 벼ɶ */

  char xname[32];		/* DɦW */		/* Thor: match HDR  xname */
  char date[9];			/* }l */		/* Thor: match HDR  date */
  char cdate[9];		/*  */		/* Thor: uܡA */  
  char owner[IDLEN + 1];	/* |H */
  char title[TTLEN + 1];	/* 벼DD */

  char vgamble;			/* O_L        '$':L  ' ':@벼 */
  char vsort;			/* }GO_Ƨ  's':Ƨ  ' ':Ƨ */
  char vpercent;		/* O_ܦʤ  '%':ʤ  ' ':@ */
  char vprivate;		/* O_pH벼    ')':pH  ' ':} */

  int maxblt;			/* CHiX */
  int price;			/* Ci䲼 */

  int limitlogins;		/* nnJWLXHWϥΪ̤~벼 */
  int limitposts;		/* noWLXHWϥΪ̤~벼 */

  char nouse[88];
}      VCH;


typedef char vitem_t[32];	/* 벼ﶵ */


typedef struct
{
  char userid[IDLEN + 1];
  char numvotes;		/* Xi */
  usint choice;
}      VLOG;


/* filepath : brd/<board>/.VCH, brd/<board>/@/... */


/* ----------------------------------------------------- */
/* Mail-Queue struct : 256 bytes			 */
/* ----------------------------------------------------- */


typedef struct
{
  time_t mailtime;		/* HHɶ */
  char method;
  char sender[IDLEN + 1];
  char username[UNLEN + 1];
  char subject[TTLEN + 1];
  char rcpt[60];
  char filepath[77];
  char *niamod;			/* reverse domain */
}      MailQueue;


#define MQ_JUSTIFY	0x01	/* {ҫH */
#define MQ_ATTACH	0x02	/*  attachment H */


/* ----------------------------------------------------- */
/* PAL : friend struct : 64 bytes			 */
/* ----------------------------------------------------- */


typedef struct
{
  char userid[IDLEN + 1];
  char ftype;
  char ship[46];
  int userno;
}      PAL;

#define	PAL_BAD		0x02	/* n vs aH */


/* ----------------------------------------------------- */
/* structure for call-in message : 100 bytes		 */
/* ----------------------------------------------------- */


typedef struct
{
  time_t btime;
  UTMP *caller;			/* who call-in me ? */
  int sender;			/* calling userno */
  int recver;			/* called userno */
  char userid[IDLEN + 1 + 2];	/* itoc.010529: Od 2 byte sŸ > */
  char msg[69];			/* y */
}      BMW;			/* bbs message write */


#ifdef LOGIN_NOTIFY

/* ----------------------------------------------------- */
/* BENZ : tΨMW : 20 bytes			 */
/* ----------------------------------------------------- */


typedef struct
{
  int userno;
  char userid[IDLEN + 1];
}       BENZ;

#endif	/* LOGIN_NOTIFY */


#ifdef HAVE_ALOHA

/* ----------------------------------------------------- */
/* ALOHA : WqW : 20 bytes			 */
/* ----------------------------------------------------- */


typedef struct
{
  char userid[IDLEN + 1];
  int userno;
}      ALOHA;


/* ----------------------------------------------------- */
/* FRIENZ : WqW : 100 bytes			 */
/* ----------------------------------------------------- */


/* itoc.041011.: ڥSnγoj */

typedef struct
{
  int nouse1;
  int nouse2;
  int nouse3;
  int userno;
  char userid[IDLEN + 1];
  char nouse4[71];
}      FRIENZ;

#endif	/* HAVE_ALOHA */


/* ----------------------------------------------------- */
/* PAYCHECK : 䲼 : 32 bytes				 */
/* ----------------------------------------------------- */


typedef struct
{
  time_t tissue;		/* o䲼ɶ */
  int money;
  int gold;
  char reason[20];		/* "[ʧ@] brdname/userid"A] BNLENBIDLEN WL 12 */
}      PAYCHECK;


/* ----------------------------------------------------- */
/* Structure used in UTMP file : 128 bytes		 */
/* ----------------------------------------------------- */


struct UTMP
{
  pid_t pid;			/* process ID */
  int userno;			/* user number */

  int mode;			/* bbsmode */
  usint userlevel;		/* the save as ACCT.userlevel */
  usint ufo;			/* the same as ACCT.ufo */
  usint status;			/* status */

  time_t idle_time;		/* active time for last event */
  u_long in_addr;		/* Internet address */
  int sockport;			/* socket port for talk */
  UTMP *talker;			/* who talk-to me ? */

  BMW *mslot[BMW_PER_USER];

  char userid[IDLEN + 1];	/* user's ID */
  char mateid[IDLEN + 1];	/* partner's ID */
  char username[UNLEN + 1];	/* user's nickname */
  char from[34];		/* remote host */
#ifdef HAVE_BRDMATE
  char reading[BNLEN + 1];	/* reading board */
#endif

  int pal_max;			/* XӪB */
  int pal_spool[PAL_MAX];	/* ҦBͪ userno */

#ifdef BMW_COUNT
  int bmw_count;		/* OFXӤy */
#endif
};


/* ----------------------------------------------------- */
/* BOARDS struct : 128 bytes				 */
/* ----------------------------------------------------- */


typedef struct BoardHeader
{
  char brdname[BNLEN + 1];	/* board name */
  char class[BCLEN + 1];
  char title[BTLEN + 1];
  char BM[BMLEN + 1];		/* BMs' uid, token '/' */

  char bvote;			/* 0:L벼 -1:L(i঳벼) 1:벼 */

  time_t bstamp;		/* إ߬ݪOɶ, unique */
  usint readlevel;		/* \Ū峹v */
  usint postlevel;		/* o峹v */
  usint battr;			/* ݪOݩ */
  time_t btime;			/* -1:bpost/blast ݭns */
  int bpost;			/* @Xg post */
  time_t blast;			/* ̫@g post ɶ */
}           BRD;


typedef struct
{
  int pal_max;			/* XӪO */
  int pal_spool[PAL_MAX];	/* ҦOͪ userno */
}	BPAL;


/* ----------------------------------------------------- */
/* Class image						 */
/* ----------------------------------------------------- */


#define CLASS_INIFILE		"Class"

/* itoc.010413:  class.img G */
#define CLASS_IMGFILE_NAME	"run/classname.img"
#define CLASS_IMGFILE_TITLE	"run/classtitle.img"


#define CH_MAX		100	/* ̤jƥ */
#define	CH_END		-1
#define	CH_TTLEN	64


typedef	struct
{
  int count;
  char title[CH_TTLEN];
  short chno[0];
}	ClassHeader;


#ifdef MY_FAVORITE

/* ----------------------------------------------------- */
/* favor.c BΪƵc                              */
/* ----------------------------------------------------- */


typedef struct MF
{
  time_t chrono;		/* إ߮ɶ */
  int mftype;			/* type */
  char xname[BNLEN + 1];	/* OWɦW */
  char class[BCLEN + 1];	/*  */
  char title[BTLEN + 1];	/* DD */
}	MF;

#define	MF_MARK		0x01	/* Q mark _Ӫ */
#define	MF_BOARD    	0x02	/* ݪO| */
#define	MF_FOLDER   	0x04	/* v */
#define	MF_GEM      	0x08	/* ذϱ| */
#define MF_LINE		0x10	/* ju */
#define MF_CLASS	0x20	/* s */

#endif  /* MY_FAVORITE */


#ifdef HAVE_COSIGN

/* ----------------------------------------------------- */
/* newbrd.c BΪƵc                             */
/* ----------------------------------------------------- */


typedef struct NewBoardHeader
{
  char brdname[BNLEN + 1];
  char class[BCLEN + 1];
  char title[BTLEN + 1];
  time_t btime;
  time_t etime;
  char xname[32];
  char owner[IDLEN + 1];
  char date[9];
  usint mode;
  int total;
}	NBRD;


#define NBRD_FINISH	0x00001	/* w */
#define NBRD_END	0x00002	/* sp */
#define NBRD_START	0x00004	/* sp}l */
#define NBRD_ANONYMOUS	0x00100	/* ΦW */
#define NBRD_NEWBOARD	0x10000	/* sOsp */
#define NBRD_OTHER	0x20000	/* Lsp */

#endif	/* HAVE_COSIGN */


#ifdef LOG_SONG_USIES

/* ----------------------------------------------------- */
/* SONG log BΪƵc                             */
/* ----------------------------------------------------- */

typedef struct SONGDATA
{
  time_t chrono;
  int count;		/* QI */
  char title[80];
}	SONGDATA;

#endif	/* LOG_SONG_USIES */


/* ----------------------------------------------------- */
/* cache.c BΪƵc				 */
/* ----------------------------------------------------- */


typedef struct
{
  int shot[MOVIE_MAX];	/* Thor.980805: Xzd 0..MOVIE_MAX - 1 */
  char film[MOVIE_SIZE];
  char today[16];
} FCACHE;


#define	FILM_SIZ	4000	/* max size for each film */


#define FILM_OPENING0	0	/* }Ye() */
#define FILM_OPENING1	1	/* }Ye() */
#define FILM_OPENING2	2	/* }Ye() */
#define FILM_GOODBYE	3	/* Ae */
#define FILM_NOTIFY	4	/* |qL{ҳq */
#define FILM_MQUOTA	5	/* HWLOsq */
#define FILM_MAILOVER	6	/* HʼƹLhq */
#define FILM_MGEMOVER	7	/* ӤHذϹLhq */
#define FILM_BIRTHDAY	8	/* ͤѪWe */
#define FILM_APPLY	9	/* Uܵe */
#define FILM_JUSTIFY	10	/* {Ҫk */
#define FILM_REREG	11	/* s{һ */
#define FILM_EMAIL	12	/* lHc{һ */
#define FILM_NEWUSER	13	/* sW */
#define FILM_TRYOUT	14	/* KX~ */
#define FILM_POST	15	/* 峹o */
#define FILM_MOVIE	16	/* ʺAݪO FILM_MOVIE nb̫᭱ */


typedef struct
{
  UTMP uslot[MAXACTIVE];	/* UTMP slots */
  usint count;			/* number of active session */
  usint offset;			/* offset for last active UTMP */

  double sysload[3];
  int avgload;

  BMW *mbase;			/* sequential pointer for BMW */
  BMW mpool[BMW_MAX];
} UCACHE;


typedef struct
{
  BRD bcache[MAXBOARD];
  BPAL pcache[MAXBOARD];
  int mantime[MAXBOARD];	/* UOثeh֤Hb\Ū */
  int number;			/* ݪOƥ */
  int numberOld;		/* }ɬݪOƥ */
  int min_chn;			/* O`@XӤ */
  time_t uptime;
} BCACHE;


/* ----------------------------------------------------- */
/* visio.c BΪƵc				 */
/* ----------------------------------------------------- */


/* Screen Line buffer modes */


#define SL_MODIFIED	(1)	/* if line has been modifed, screen output */
#define SL_STANDOUT	(2)	/* if this line contains standout code */
#define SL_ANSICODE	(4)	/* if this line contains ANSI code */


typedef struct screenline
{
  int oldlen;			/* previous line length */
  int len;			/* current length of line */
  int width;			/* padding length of ANSI codes */
  int smod;			/* start of modified data */
  int emod;			/* end of modified data */
  int sso;			/* start of standout data */
  int eso;			/* end of standout data */
  uschar mode;			/* status of line, as far as update */	/* ѩ SL_*  mode WLKӡAG uschar Yi */
  uschar data[ANSILINELEN];
}          screenline;


typedef struct LinkList
{
  struct LinkList *next;
  char data[0];
}        LinkList;


/* ----------------------------------------------------- */
/* xover.c BΪƵc				 */
/* ----------------------------------------------------- */


typedef struct OverView
{
  int pos;			/* current position */
  int top;			/* top */
  int max;			/* max */
  int key;			/* key */
  char *xyz;			/* staff */
  struct OverView *nxt;		/* next */
  char dir[0];			/* data path */
}        XO;


typedef struct
{
  int key;
  int (*func) ();
}      KeyFunc;


typedef struct
{
  XO *xo;
  KeyFunc *cb;
  int mode;
  char *feeter;
} XZ;


typedef struct
{
  time_t chrono;
  int recno;
}      TagItem;


/* ----------------------------------------------------- */
/* poststat.c BΪƵc				 */
/* ----------------------------------------------------- */


typedef struct
{
  char author[IDLEN + 1];
  char board[BNLEN + 1];
  char title[66];
  time_t date;		/* last post's date */
  int number;		/* post number */
} POSTLOG;


#ifdef MODE_STAT

/* ----------------------------------------------------- */
/* modestat.c BΪƵc				 */
/* ----------------------------------------------------- */

typedef struct
{
  time_t logtime;
  time_t used_time[M_MAX + 1];	/* itoc.010901: depend on mode.h */
} UMODELOG;


typedef struct
{
  time_t logtime;
  time_t used_time[M_MAX + 1];	/* itoc.010901: depend on mode.h */
  int count[30];
  int usercount;
} MODELOG;

#endif	/* MODE_STAT */


/* ----------------------------------------------------- */
/* innbbsd BΪƵc				 */
/* ----------------------------------------------------- */


typedef struct
{
  time_t chrono;	/* >=0:stamp -1:cancel */
  char board[BNLEN + 1];

  /* HU쪺jpP HDR ۦP */
  char xname[32];
  char owner[80];
  char nick[49];
  char title[TTLEN + 1];
} bntp_t;


#define INN_USEIHAVE	0x0001
#define INN_USEPOST	0x0002
#define INN_FEEDED	0x0010

typedef struct
{
  char name[13];	/* ӯ short-name */
  char host[83];	/* ӯ host */
  int port;		/* ӯ port */
  usint xmode;		/* ӯ xmode */
  char blank[20];	/* Od */
  int feedfd;		/* bbslink.c ϥ */
} nodelist_t;


#define INN_NOINCOME	0x0001
#define INN_ERROR	0x0004

typedef struct
{
  char path[13];	/* Ӹsթҹ઺x */
  char newsgroup[83];	/* ӸsժW */
  char board[BNLEN + 1];/* ӸsթҹݪO */
  char charset[11];	/* Ӹsժr */
  usint xmode;		/* Ӹsժ xmode */
  int high;		/* ثeӸsժ@g */
} newsfeeds_t;


typedef struct
{
  char issuer[128];	/* NCM message oHH */
  char type[64];	/* NCM message W */
  int perm;		/* \ NCM message RH (1:} 0:) */
  char blank[60];	/* Od */
} ncmperm_t;


#define INN_SPAMADDR	0x0001
#define INN_SPAMNICK	0x0002
#define INN_SPAMSUBJECT	0x0010
#define INN_SPAMPATH	0x0020
#define INN_SPAMMSGID	0x0040
#define INN_SPAMBODY	0x0100
#define INN_SPAMSITE	0x0200
#define INN_SPAMPOSTHOST 0x0400

typedef struct
{
  char detail[80];	/* ӳWh e */
  usint xmode;		/* ӳWh xmode */
  char board[BNLEN + 1];/* ӳWhAΪݪO */
  char path[13];	/* ӳWhAΪx */
  char blank[18];	/* Od */
} spamrule_t;

#endif				/* _STRUCT_H_ */
