/*-------------------------------------------------------*/
/* mine.c         ( NTHU CS MapleBBS Ver 3.10 )          */
/*-------------------------------------------------------*/
/* target : apC                                   */
/* create : 01/02/15                                     */
/* update : 01/03/01                                     */
/* author : piaip.bbs@sob.twbbs.org                      */
/* recast : itoc.bbs@bbs.tnfsh.tn.edu.tw                 */
/*-------------------------------------------------------*/


#include "bbs.h"

#ifdef HAVE_GAME

#define _CHINESE_	/* r symbol */

enum
{
  /* MINE_XPOS + MAP_MAX_X np b_lines - 2 = 21    *
   * MINE_YPOS + MAP_MAX_Y * 2 np STRLEN - 1 = 79 *
   * MINE_YPOS n out_prompt() J             */

  MINE_XPOS = 0,
  MINE_YPOS = 17,
  MAP_MAX_X = 20,		/*  x V */
  MAP_MAX_Y = 30,		/*  y V */

  /* These are flags for bitwise operators */
  TILE_BLANK = 0,		/* Sap */
  TILE_MINE = 1,		/* ap */
  TILE_TAGGED = 0x10,		/* QаO */
  TILE_EXPAND = 0x20		/* wQi} */
};


static char MineMap[MAP_MAX_X + 2][MAP_MAX_Y + 2];	/* aϤWC檺ݩ */
static char MineNei[MAP_MAX_X + 2][MAP_MAX_Y + 2];	/* aϤWCF~h֦ap */

static int MAP_X, MAP_Y;	/* ѽLjp */
static int cx, cy;		/* current (x, y) */
static int TotalMines;		/* wаOap */
static int TaggedMines;		/* wаOap */
static time_t InitTime;		/* }lɶ */
static int LoseGame;		/* 1: F     0: ٦b */
static int EndGame;		/* 1: }C 0: ٦b */


#ifdef _CHINESE_
static char symTag[3] = "";	/* аOap/BapBQХ */
static char symMine[3] = "";	/* /BapSQХ */
static char symWrong[3] = "";	/* /BSapQХ */
static char symBlank[3] = "";	/* Qi}/BSapBSQi} */
static char *strMines[9] = {"@", "", "", "", "", "", "", "", ""};	/* 䦳Xap */
#else
static char symTag[3] = " M";
static char symMine[3] = " m";
static char symWrong[3] = " X";
static char symBlank[3] = " o";
static char *strMines[9] = {" _", " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8"};
#endif


static inline int
count_neighbor(x, y, bitmask)
  int x, y, bitmask;
{
  return (((MineMap[x - 1][y - 1] & bitmask) + (MineMap[x - 1][y] & bitmask) +
    (MineMap[x - 1][y + 1] & bitmask) + (MineMap[x][y - 1] & bitmask) +
    (MineMap[x][y] & bitmask) + (MineMap[x][y + 1] & bitmask) +
    (MineMap[x + 1][y - 1] & bitmask) + (MineMap[x + 1][y] & bitmask) +
    (MineMap[x + 1][y + 1] & bitmask)) / bitmask);
}


static void
init_map()
{
  int x, y, i;

  /* ]wĴѽL */

  for (x = 0; x < MAP_X + 2; x++)
  {
    for (y = 0; y < MAP_Y + 2; y++)
    {
      MineMap[x][y] = TILE_BLANK;
      if (x == 0 || y == 0 || x == MAP_X + 1 || y == MAP_Y + 1)
	MineMap[x][y] |= TILE_EXPAND;
    }
  }

  /* ]wapҦb */

  for (i = 0; i < TotalMines;)
  {
    x = rnd(MAP_X) + 1;
    y = rnd(MAP_Y) + 1;

    if (MineMap[x][y] == TILE_BLANK)
    {
      MineMap[x][y] = TILE_MINE;
      i++;
    }
  }

  /* XҦ檺F~h֦ap */

  for (x = 1; x <= MAP_X; x++)
  {
    for (y = 1; y <= MAP_Y; y++)
    {
      MineNei[x][y] = count_neighbor(x, y, TILE_MINE);
    }
  }

  /* {b}lpɡA] out_map()  out_info() nΨ */
  InitTime = time(0);
}


static void
out_prompt()
{
  /* outs() ̭ԭzoWL MINE_YPOSA_h| */
  move(3, 0);
  outs("仡G");
  move(5, 0);
  outs("     V");
  move(7, 0);
  outs("½}     ť");
  move(9, 0);
  outs("аOap   ");
  move(11, 0);
  outs("p       ");
  move(13, 0);
  outs("}       ");
}


static inline void
out_song()
{
  uschar *msg[8] = 
  {
    "DFyLHӡADRLHP",			/* ѸG|l */
    "@@AoӤFbb\\AO}",	/* lPa樥 */
    "yBӺ[A{ӱ",			/* lPa樥 */
    "LAֲּw",				/* j */
    "jǤDAbwAb˥Abܵ",		/* j */
    "ѩRשʡAvʤwDADױ",		/* e */
    "wHvAwH]",			/* ׻yǦ */
    "»DDAiio"					/* ׻y */
  };
  move(b_lines - 2, 0);
  prints("\033[1;3%dm%s\033[m", time(0) % 7, msg[time(0) % 8]);
  clrtoeol();
}


static void
out_info()
{
  move(b_lines - 1, 0);
  prints("Ҫɶ: %.0lf AѤU %d ӦapаOC",
    difftime(time(0), InitTime), TotalMines - TaggedMines);
  clrtoeol();

  out_song();
}


static inline void
out_map()
{
  int x, y;

  vs_bar("lzap");

  for (x = 1; x <= MAP_X; x++)
  {
    move(MINE_XPOS + x, MINE_YPOS + 2);
    for (y = 1; y <= MAP_Y; y++)
      outs(symBlank);
  }

  out_prompt();
  out_info();
  move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);	/* move to (0, 0) */
}


static void
draw_map()			/* eX㵪 */
{
  int x, y;

  vs_bar("lzap");

  for (x = 1; x <= MAP_X; x++)
  {
    move(MINE_XPOS + x, MINE_YPOS + 2);
    for (y = 1; y <= MAP_Y; y++)
    {
      if (MineMap[x][y] & TILE_TAGGED)
      {
	if (!(MineMap[x][y] & TILE_MINE))
	  outs(symWrong);
	else
	  outs(symTag);
      }
      else if (MineMap[x][y] & TILE_EXPAND)
	outs(strMines[MineNei[x][y]]);
      else if (MineMap[x][y] & TILE_MINE)
	outs(symMine);
      else
	outs(symBlank);
    }
  }
}


static void
expand_map(x, y)
  int x, y;
{
  if (MineMap[x][y] & TILE_TAGGED || MineMap[x][y] & TILE_EXPAND)
    return;

  if (MineMap[x][y] & TILE_MINE && !(MineMap[x][y] & TILE_TAGGED))
  {
    LoseGame = 1;
    return;
  }

  MineMap[x][y] |= TILE_EXPAND;
  move(MINE_XPOS + x, MINE_YPOS + y * 2);
  outs(strMines[MineNei[x][y]]);

  if (MineNei[x][y] == 0)
  {
    if ((MineMap[x - 1][y] & TILE_EXPAND) == 0)
      expand_map(x - 1, y);
    if ((MineMap[x][y - 1] & TILE_EXPAND) == 0)
      expand_map(x, y - 1);
    if ((MineMap[x + 1][y] & TILE_EXPAND) == 0)
      expand_map(x + 1, y);
    if ((MineMap[x][y + 1] & TILE_EXPAND) == 0)
      expand_map(x, y + 1);
    if ((MineMap[x - 1][y - 1] & TILE_EXPAND) == 0)
      expand_map(x - 1, y - 1);
    if ((MineMap[x + 1][y - 1] & TILE_EXPAND) == 0)
      expand_map(x + 1, y - 1);
    if ((MineMap[x - 1][y + 1] & TILE_EXPAND) == 0)
      expand_map(x - 1, y + 1);
    if ((MineMap[x + 1][y + 1] & TILE_EXPAND) == 0)
      expand_map(x + 1, y + 1);
  }
}


static inline void
trace_map(x, y)
  int x, y;
{
  if (MineMap[x][y] & TILE_EXPAND &&
    MineNei[x][y] == count_neighbor(x, y, TILE_TAGGED))
  {
    expand_map(x - 1, y);
    expand_map(x, y - 1);
    expand_map(x + 1, y);
    expand_map(x, y + 1);
    expand_map(x - 1, y - 1);
    expand_map(x + 1, y - 1);
    expand_map(x - 1, y + 1);
    expand_map(x + 1, y + 1);
  }
}


static inline void
play_mine()
{
  int ch;

  LoseGame = 0;
  EndGame = 0;

  while (!LoseGame && (ch = vkey()))
  {
    switch (ch)
    {
    case KEY_ESC:
    case 'q':
      EndGame = 1;
      return;

      /* ʧ@nЦ^_Ӫm */

    case KEY_UP:
      if (cx > 1)
      {
	cx--;
	move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      }
      break;

    case KEY_DOWN:
      if (cx < MAP_X)
      {
	cx++;
	move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      }
      break;

    case KEY_LEFT:
      if (cy > 1)
      {
	cy--;
	move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      }
      break;

    case KEY_RIGHT:
      if (cy < MAP_Y)
      {
	cy++;
	move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      }
      break;

    case 'd':
    case '\n':
      trace_map(cx, cy);
      out_info();
      move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      break;

    case ' ':
      expand_map(cx, cy);
      out_info();
      move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      break;

    case 'f':
      if (MineMap[cx][cy] & TILE_EXPAND)
      {
	if (MineMap[cx][cy] & TILE_TAGGED)	/* ӳQаO,  */
	{
	  TaggedMines--;
	  MineMap[cx][cy] ^= TILE_EXPAND;
	  MineMap[cx][cy] ^= TILE_TAGGED;
	  move(MINE_XPOS + cx, MINE_YPOS + cy * 2);
	  outs(symBlank);
	}
      }
      else		/* ӨSаO, WаO */
      {
	TaggedMines++;
	MineMap[cx][cy] ^= TILE_EXPAND;
	MineMap[cx][cy] ^= TILE_TAGGED;
	move(MINE_XPOS + cx, MINE_YPOS + cy * 2);
	outs(symTag);
	if (TaggedMines == TotalMines)
	  return;
      }
      out_info();
      move(MINE_XPOS + cx, MINE_YPOS + cy * 2 + 1);
      break;

    default:
      break;
    }
  }
}


static inline int
win()
{
  int x, y;

  for (x = 1; x <= MAP_X; x++)
  {
    for (y = 1; y <= MAP_Y; y++)
    {
      if (((MineMap[x][y] & TILE_TAGGED) && !(MineMap[x][y] & TILE_MINE)) ||
        (!(MineMap[x][y] & TILE_TAGGED) && (MineMap[x][y] & TILE_MINE)))
      {
        return 0;		/* пa */
      }
    }
  }
  return 1;
}


int
main_mine()
{
  int level;
  char ans[4];

  level = vans("п [1-5] šA[0] ۩wAΫ [Q] }G");
  if (level == 'q')
  {
    return XEASY;
  }
  else if (level < '1' || level > '5')	/* ۩wѽLoj 60 * 20 */
  {
    vget(b_lines, 0, "пJaϪG", ans, 3, DOECHO);
    MAP_Y = atoi(ans) > MAP_MAX_Y ? MAP_MAX_Y : atoi(ans);

    vget(b_lines, 0, "пJaϪeG", ans, 3, DOECHO);
    MAP_X = atoi(ans) > MAP_MAX_X ? MAP_MAX_X : atoi(ans);

    vget(b_lines, 0, "пJapơG", ans, 3, DOECHO);
    level = atoi(ans);
    TotalMines = MAP_Y * MAP_X / 3;
    if (TotalMines > level)
      TotalMines = level;
    /* apƤoWL MAP_Y * MAP_X / 3AHK init_map() üƨӤ[ */

    if (MAP_Y < 1 || MAP_X < 1 || TotalMines < 1)
      return 0;
    level = 0;
  }
  else
  {
    level -= '0';
    MAP_Y = 5 * level;		/* oWL MAP_MAX_Y */
    MAP_X = (level < 4) ? 5 * level : MAP_MAX_X;	/* oWL MAP_MAX_X */
    TotalMines = MAP_Y * MAP_X / 10;
  }

  TaggedMines = 0;
  cx = MAP_X / 2 + 1;
  cy = MAP_Y / 2 + 1;

  init_map();
  out_map();
  play_mine();

  if (!EndGame)
  {
    if (LoseGame)
    {
      draw_map();
      vmsg("IIapFI");
    }
    else	/* аO == ap */
    {
      if (win())	/* itoc.010711: nˬdO_}AHKHKüаOAаO=apƴNLF */
      {
	char buf[STRLEN];
	sprintf(buf, "zF %.0lf  } %d  nR ^O^", difftime(time(0), InitTime), level);
	vmsg(buf);
	addmoney(level * 75);
      }
      else
      {
        draw_map();
        vmsg("zпapF =.=");
      }
    }
  }
  else
  {
    vmsg(MSG_QUITGAME);
  }

  return 0;
}
#endif	/* HAVE_GAME */
