/*-------------------------------------------------------*/
/* fantan.c	( NTHU CS MapleBBS Ver 3.10 )		 */
/*-------------------------------------------------------*/
/* target : sC					 */
/* create : 98/08/04					 */
/* update : 01/03/01					 */
/* author : dsyan.bbs@Forever.twbbs.org			 */
/* recast : itoc.bbs@bbs.tnfsh.tn.edu.tw		 */
/*-------------------------------------------------------*/


#include "bbs.h"

#ifdef HAVE_GAME

enum
{
  SIDE_UP = 1,				/* bW */
  SIDE_DOWN = 0				/* bU */
};


static inline int
cal_kind(card)				/*  */
  int card;
{
  /* card:  1 - 13 ġت 
	   14 - 26 Ĥ@ت 
	   27 - 39 ĤGت 
	   40 - 52 ĤTت  */

  return (card - 1) / 13;
}


static inline int 
cal_num(card)				/* I */
  int card;
{
  card %= 13;
  return card ? card : 13;
}


static void
move_cur(a, b, c, d)			/* ʽb */
  int a, b;		/* m */
  int c, d;		/* sm */
{
  move(a, b);
  outs("  ");
  move(c, d);
  outs("");
  move(c, d + 1);	/* קK۰ʰ */
}


static inline int
ycol(y)					/* y */
  int y;
{
  return y * 11 - 8;
}


static void
draw(x, y, card)			/* eP */
  int x, y;
  int card;
{
  char kind[4][3] = {"", "", "", ""};			/*  */
  char num[13][3] = {"", "", "", "", "", "", "",	/* I */
		     "", "", "", "", "", ""};

  move(x, y);

  if (card > 0)
    prints("u%s%st", kind[cal_kind(card)], num[cal_num(card) - 1]);
  else if (!card)
    outs("uwwt");
  else
    outs("        ");
}


static inline void
out_prompt()			/* ܦr */
{
  move(b_lines - 1, 0);
  outs(COLOR2 " (q)} (r) () ()½ (Enter)| (Space)w//½P    \033[m");
}


static char
get_newcard(mode)
  int mode;			/* 0:s~P  1:oP */
{
  static char card[52];		/* ̦hu|Ψ 52 iP */
  static int now;		/* oX now iP */
  int i, num;
  char tmp;

  if (!mode)   /* s~P */
  {
    for (i = 0; i < 52; i++)
      card[i] = i + 1;

    for (i = 0; i < 51; i++)
    {
      num = rnd(52 - i) + i;

      /* card[num] M card[i] 洫 */
      tmp = card[i];
      card[i] = card[num];
      card[num] = tmp;
    }

    now = 0;
    return -1;
  }

  tmp = card[now];
  now++;
  return tmp;
}


int
main_fantan()
{
  char max[9];				/* C諸PơAĤKOWP */
  char rmax[8];				/* C良|Q½}P */

  char left_stack[25];			/* W 24 iP */
  char up_stack[5];			/* kW 4 iP (unO̤jPYi) */
  char down_stack[8][21];		/* UCӰ|ҦP */

  int level;				/* @½XiP */
  int side;				/* ЦbW٬OU */

  int cx, cy;				/* ثeҦb (x, y) y */
  int xx, yy;				/* LhҦb (x, y) y */
  int star_c, star_x, star_y;		/*  '*' B PBy */
  int left;				/* W|½ĴXi */

  int i, j;

  time_t init_time;			/* C}lɶ */

  level = vans("пܤ@½ [1~3] @T iPAΫ [Q] }G");
  if (level > '0' && level < '4')
    level -= '0';
  else
    return XEASY;

game_start:
  vs_bar("s");
  out_prompt();

  side = SIDE_DOWN;
  star_c = 0;
  star_x = 2;
  star_y = 79;

  for (i = 0; i <= 4; i++)			/* W|Ӱ|ks */
    up_stack[i] = 0;

  get_newcard(0);	/* ~P */

  for (i = 1; i <= 7; i++)
  {
    max[i] = i;					/*  i }l i iP */
    rmax[i] = i - 1;				/*  i }l i-1 i} */
    for (j = 1; j <= i; j++)
    {
      down_stack[i][j] = get_newcard(1);	/* tmUP */
      draw(j + 2, ycol(i), i != j ? 0 : down_stack[i][j]);	/* C若}̫@iP */
    }
  }

  max[8] = 24;					/* W}l 24 iP */
  for (i = 1; i <= 24; i++)
    left_stack[i] = get_newcard(1);		/* tmWP */
  draw(1, 1, 0);

  left = 0;
  cx = 1;
  cy = 1;
  xx = 1;
  yy = 1;

  init_time = time(0);		/* }lOɶ */

  for (;;)
  {
    if (side == SIDE_DOWN)
    {
      move_cur(xx + 2, ycol(yy) - 2, cx + 2, ycol(cy) - 2);
      xx = cx;
      yy = cy;

      switch (vkey())
      {
      case 'q':
	vmsg(MSG_QUITGAME);
	return;

      case 'r':
	goto game_start;

      case KEY_LEFT:
	cy--;
	if (!cy)
	  cy = 7;
	if (cx > max[cy] + 1)
	  cx = max[cy] + 1;
	break;

      case KEY_RIGHT:
	cy++;
	if (cy == 8)
	  cy = 1;
	if (cx > max[cy] + 1)
	  cx = max[cy] + 1;
	break;

      case KEY_DOWN:
	cx++;
	if (cx == max[cy] + 2)
	  cx--;
	break;

      case KEY_UP:
	cx--;
	if (!cx)					/* ]WhF */
	{
	  side = SIDE_UP;
	  move_cur(xx + 2, ycol(yy) - 2, 1, 9);
	}
	break;

      case '\n':				/* PkW */
	j = down_stack[cy][cx];
	if ((cal_num(j) == up_stack[cal_kind(j)] + 1) && cx == max[cy] && cx > rmax[cy])
	{
	  up_stack[cal_kind(j)]++;
	  max[cy]--;
	  draw(1, cal_kind(j) * 10 + 40, j);
	  draw(cx + 2, ycol(cy), -1);
	  if (star_c == j)			/* pGON */
	  {
	    move(star_x, star_y);
	    outc(' ');
	  }
	}
	/* }: kW|ӳO 13 */
	if (up_stack[0] & up_stack[1] & up_stack[2] & up_stack[3] == 13)
	{
	  char buf[80];
	  sprintf(buf, "zF %.0lf  } %d  nR ^O^", 
	    difftime(time(0), init_time), level);
	  vmsg(buf);
	  addmoney(level * 100);
	  return;	  
	}
	break;

      case ' ':
	if (cx == max[cy] && cx == rmax[cy])	/* ½sP */
	{
	  rmax[cy]--;
	  draw(cx + 2, ycol(cy), down_stack[cy][cx]);
	  break;
	}
	else if (cx > rmax[cy] && cx <= max[cy])	/* ŤU */
	{
	  move(star_x, star_y);
	  outc(' ');
	  star_c = down_stack[cy][cx];
	  star_x = cx + 2;
	  star_y = cy * 11;
	  move(star_x, star_y);
	  outc('*');
	  break;
	}
	else if (cx != max[cy] + 1)
	  break;				/* KW */

	if ((max[cy] && (cal_num(down_stack[cy][max[cy]]) == cal_num(star_c) + 1) && 
	  (cal_kind(down_stack[cy][max[cy]]) + cal_kind(star_c)) % 2) ||
	  (max[cy] == 0 && cal_num(star_c) == 13))
	{
	  if (star_x == 1)		/* qWKUӪ */
	  {
	    max[cy]++;
	    max[8]--;
	    star_x = 2;
	    left--;
	    for (i = left + 1; i <= max[8]; i++)
	      left_stack[i] = left_stack[i + 1];
	    down_stack[cy][max[cy]] = star_c;
	    draw(max[cy] + 2, ycol(cy), star_c);
	    move(1, 19);
	    outc(' ');
	    draw(1, 11, left ? left_stack[left] : -1);
	  }
	  else if (star_x > 2)		/* bUKӶKh */
	  {
	    int tmp;;
	    j = star_y / 11;
	    tmp = max[j];	    
	    for (i = star_x - 2; i <= tmp; i++)
	    {
	      max[cy]++;
	      max[j]--;
	      down_stack[cy][max[cy]] = down_stack[j][i];
	      draw(max[cy] + 2, ycol(cy), down_stack[cy][max[cy]]);
	      draw(i + 2, ycol(j), -1);
	    }
	    move(star_x, star_y);
	    outc(' ');
	    star_x = 2;
	  }
	}
	break;
      }

    }
    else /* side == SIDE_UP */	/* bW */
    {
      draw(1, 11, left ? left_stack[left] : -1);

      switch (vkey())
      {
      case 'q':
	vmsg(MSG_QUITGAME);
	return;

      case 'r':
	goto game_start;

      case '\n':				/* PkW */
	j = left_stack[left];
	if (cal_num(j) == up_stack[cal_kind(j)] + 1)
	{
	  up_stack[cal_kind(j)]++;
	  max[8]--;
	  left--;
	  draw(1, cal_kind(j) * 10 + 40, j);

	  for (i = left + 1; i <= max[8]; i++)
	    left_stack[i] = left_stack[i + 1];

	  draw(1, 11, left ? left_stack[left] : -1);

	  if (star_x == 1)	/* pGONM */
	  {
	    star_x = 2;
	    move(1, 19);
	    outc(' ');
	  }
	  /* }: kW|ӳO 13 */
	  if (up_stack[0] & up_stack[1] & up_stack[2] & up_stack[3] == 13)
	  {
	    char buf[80];
	    sprintf(buf, "zF %.0lf  } %d  nR ^O^", 
	      difftime(time(0), init_time), level);
	    vmsg(buf);
	  }
	}
	break;

      case KEY_DOWN:
	side = SIDE_DOWN;
	cx = 1;
	move_cur(1, 9, cx + 2, ycol(cy) - 2);
	break;

      case KEY_UP:
	if (left == max[8])
	  left = 0;
	else
	  left += level;	/* @o level iP */
	if (left > max[8])
	  left = max[8];

	if (star_x == 1)
	{
	  star_x = 2;
	  move(1, 19);
	  outc(' ');
	}

	draw(1, 1, left == max[8] ? -1 : 0);
	break;

      case ' ':
	if (left > 0)
	{
	  move(star_x, star_y);
	  outc(' ');
	  star_c = left_stack[left];
	  star_x = 1;
	  star_y = 19;
	  move(1, 19);
	  outc('*');
	}
	break;
      }
    }
  }
}
#endif	/* HAVE_GAME */
